package com.agilex.healthcare.mbb.controller.soc;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationFilter;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.problem.ProblemDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.surgery.SurgeryDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;
import com.agilex.healthcare.mobilehealthplatform.domain.Surgeries;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

@Controller
public class PatientSummaryClinicalDomainController extends AbstractUserResource {
	protected static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(PatientSummaryClinicalDomainController.class);

	@RequestMapping(value = "/summary", method = RequestMethod.GET)
	public String getPatientSummary(HttpServletRequest req, Model model) {
		PatientIdentifier patientIdentifier = getPatientIdentifier();
		
		PatientDemographics demographics = null;
		Patient patient = null;
		Allergies allergies = null;
		Medications medications = null;
		Problems problems = null;
		Surgeries surgeries = null;
		
		try {
			PatientDataService patientDataService = new PatientDataService();

			demographics = patientDataService.getPatientDemographics(patientIdentifier, ScopeFilter.getInstanceForLongitudinalScope());
			patient = MhpUserFactory.createFromSecurityContext().getPatient();
			
			AllergyDataService allergyDataService = new AllergyDataService();
			allergies = allergyDataService.fetchPatientAllergies(patientIdentifier, ScopeFilter.getInstanceForLongitudinalScope());
			
			MedicationDataService medicationDataService = new MedicationDataService();
			MedicationFilter filter = MedicationFilterFactory.createEmptyFilter();
			medications = medicationDataService.getActiveAndRecentlyExpiredPatientMedications(patientIdentifier, filter, ScopeFilter.getInstanceForLongitudinalScope());
			
			ProblemDataService problemDataService = new ProblemDataService();
			problems = problemDataService.fetchProblems(patientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
			
			SurgeryDataService surgeryDataService = new SurgeryDataService();
			surgeries = surgeryDataService.getPatientSurgeries(patientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		} catch (Throwable t) {
			LOGGER.error(t);
			throw new RuntimeException(t);
		}
		
		model.addAttribute("demographics", demographics);
		model.addAttribute("patient", patient);
		model.addAttribute("allergies", allergies);
		model.addAttribute("medications", medications);
		model.addAttribute("problems", problems);
		model.addAttribute("surgeries", surgeries);
		
		return "soc/patientSummary";

	}
}
