package com.agilex.healthcare.mbb.controller.share;

import java.text.ParseException;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalEntryFilter;
import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalsFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalTableData;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.SessionStateHelper;
import com.agilex.healthcare.utility.objectmapper.VitalTableDataGenerator;

@Controller
public class VitalsDomainController extends AbstractUserResource {
	protected static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(VitalsDomainController.class);

	@Resource SessionStateHelper sessionStateHelper;
	
	@RequestMapping(value = "/vitals", method = RequestMethod.GET)
	public String getVitals(HttpServletRequest req, Model model, @RequestParam String startDate, @RequestParam String endDate) throws ParseException {
		String cacheKey = Domain.vital;
		PatientIdentifier patientIdentifier = getPatientIdentifier();
		DateFilter dateFilter = DateFilterFactory.createFilterFromDate(startDate, endDate);
		VitalEntryFilter filter = VitalsFilterFactory.createFilterFromDateFilter(dateFilter);
		VitalDataService dataservice = new VitalDataService();
		VitalEntries vitalEntries = null;

		Object cache = sessionStateHelper.checkCache(req.getSession(), cacheKey, dateFilter);
		if (cache != null && cache instanceof VitalEntries) {
			LOGGER.debug("Using cached VitalEntries");
			vitalEntries = (VitalEntries)cache;
		}
		
		if (vitalEntries == null) {
			LOGGER.debug("Fetching vital entries from dataservice");
			vitalEntries = dataservice.fetchVitalEntries(patientIdentifier, filter, ScopeFilter.getInstanceForLongitudinalScope());
			sessionStateHelper.addCacheMapToSession(req.getSession(), cacheKey, dateFilter, vitalEntries);
		}

		VitalTableDataGenerator tableGenerator = new VitalTableDataGenerator();
		VitalTableData vitalTableData = tableGenerator.generateVitalTableData(vitalEntries);
		vitalTableData.sortDescending("entryTime");
		
		model.addAttribute("vitals", vitalTableData);
	
		return "share/vitals";
	}
}
