package com.agilex.healthcare.mbb.controller.share;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.agilex.healthcare.mobilehealthplatform.datalayer.surgery.SurgeryDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Surgeries;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.SessionStateHelper;

@Controller
public class SurgeryClinicalDomainController extends AbstractUserResource {
	protected static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(SurgeryClinicalDomainController.class);

	@Resource SessionStateHelper sessionStateHelper;
	
	@RequestMapping(value = "/surgery", method = RequestMethod.GET)
	public String getSurgeries(HttpServletRequest req, Model model) {
		String cacheKey = Domain.surgery;
		Surgeries surgeries = null;
		PatientIdentifier patientIdentifier = getPatientIdentifier();

		Object cache = sessionStateHelper.checkCache(req.getSession(), cacheKey);
		if (cache != null && cache instanceof Surgeries) {
			LOGGER.debug("Using cached Surgeries");
			surgeries = (Surgeries)cache;
		}
		
		if (surgeries == null) {
			LOGGER.debug("Fetching surgeries from dataservice");
			try {
				SurgeryDataService dataservice = new SurgeryDataService();
				surgeries = dataservice.getPatientSurgeries(patientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
				sessionStateHelper.addCacheMapToSession(req.getSession(), cacheKey, surgeries);
			} catch (Throwable t) {
				LOGGER.error(t);
				throw new RuntimeException(t);
			}
		}

		model.addAttribute("surgeries", surgeries);

		return "share/surgeries";

	}
}
