package com.agilex.healthcare.mbb.controller.share;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.agilex.healthcare.mobilehealthplatform.datalayer.radiology.RadiologyDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResults;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.SessionStateHelper;

@Controller
public class RadiologyDomainController extends AbstractUserResource {
	protected static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(RadiologyDomainController.class);

	@Resource SessionStateHelper sessionStateHelper;
	
	@RequestMapping(value = "/radiology-result", method = RequestMethod.GET)
	public String getRadiology(HttpServletRequest req, Model model, @RequestParam String startDate, @RequestParam String endDate) {
		String cacheKey = Domain.radiologyResult;
		DateFilter dateFilter = DateFilterFactory.createFilterFromDate(startDate, endDate);

		RadiologyResults radiologyResults = null;
		PatientIdentifier patientIdentifier = getPatientIdentifier();

		Object cache = sessionStateHelper.checkCache(req.getSession(), cacheKey, dateFilter);
		if (cache != null && cache instanceof RadiologyResults) {
			LOGGER.debug("Using cached RadiologyResults");
			radiologyResults = (RadiologyResults) cache;
		}

		if (radiologyResults == null) {
			LOGGER.debug("Fetching radiology exams from dataservice");
			try {
				RadiologyDataService dataservice = new RadiologyDataService();
				radiologyResults = dataservice.getRadiologyResults(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());
				sessionStateHelper.addCacheMapToSession(req.getSession(), cacheKey, dateFilter, radiologyResults);
			} catch (Throwable t) {
				LOGGER.error(t);
				throw new RuntimeException(t);
			}
		}

		model.addAttribute("radiologyResults", radiologyResults);

		return "share/radiology";

	}
}
