package com.agilex.healthcare.mbb.controller.share;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.agilex.healthcare.mobilehealthplatform.datalayer.problem.ProblemDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.SessionStateHelper;


@Controller
public class ProblemClinicalDomainController extends AbstractUserResource {
	protected static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(ProblemClinicalDomainController.class);

	@Resource SessionStateHelper sessionStateHelper;
	
	@RequestMapping(value = "/problem", method = RequestMethod.GET)
	public String getProblems(HttpServletRequest req, Model model) {
		String cacheKey = Domain.problem;
		Problems problems = null;
		PatientIdentifier patientIdentifier = getPatientIdentifier();

		Object cache = sessionStateHelper.checkCache(req.getSession(), cacheKey);
		if (cache != null && cache instanceof Problems) {
			LOGGER.debug("Using cached Problems");
			problems = (Problems)cache;
		}
		
		if (problems == null) {
			LOGGER.debug("Fetching problems from dataservice");
			try {
				ProblemDataService dataservice = new ProblemDataService();
				problems = dataservice.fetchProblems(patientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
				sessionStateHelper.addCacheMapToSession(req.getSession(), cacheKey, problems);
			} catch (Throwable t) {
				LOGGER.error(t);
				throw new RuntimeException(t);
			}
		}
	
		
		model.addAttribute("problems", problems);
		
		return "share/problems";

	}
}
