package com.agilex.healthcare.mbb.controller.share;

import java.text.ParseException;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro.MicrobiologyLabDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.SessionStateHelper;

@Controller
public class MicroLabDomainController extends AbstractUserResource {
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(MicroLabDomainController.class);

	@Resource SessionStateHelper sessionStateHelper;
	
	@RequestMapping(value = "/lab-microbiology-result", method = RequestMethod.GET)
	public String getMicroLabs(HttpServletRequest req, Model model, @RequestParam String startDate, @RequestParam String endDate) throws ParseException {
		String cacheKey = Domain.microLabResult;
		PatientIdentifier patientIdentifier = getPatientIdentifier();
		DateFilter dateFilter = DateFilterFactory.createFilterFromDate(startDate, endDate);
		LabResults microLabResults = null;

		Object cache = sessionStateHelper.checkCache(req.getSession(), cacheKey, dateFilter);
		if (cache != null && cache instanceof LabResults) {
			LOGGER.debug("Using cached LabResults");
			microLabResults = (LabResults) cache;
		}

		if (microLabResults == null) {
			LOGGER.debug("Fetching microbiology lab results from dataservice");
            // MBB-18: Removing the chance of microbiology being called by MBB. Micro data source is not available for veterans
//			MicrobiologyLabDataService dataservice = new MicrobiologyLabDataService();
//			dataservice.getLabResultsWithTextResults(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());
            microLabResults = new LabResults();
			sessionStateHelper.addCacheMapToSession(req.getSession(), cacheKey, dateFilter, microLabResults);
		}

		model.addAttribute("microLabs", microLabResults);

		return "share/microlabs";

	}
}
