package com.agilex.healthcare.mbb.controller.share;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationFilter;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.SessionStateHelper;

@Controller
public class MedicationHistoryClinicalDomainController extends AbstractUserResource {
	protected static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(MedicationHistoryClinicalDomainController.class);

	@Resource SessionStateHelper sessionStateHelper;
	
	@RequestMapping(value = "/medication-history", method = RequestMethod.GET)
	public String getMedicationHistory(HttpServletRequest req, Model model, @RequestParam String startDate, @RequestParam String endDate) {
		String cacheKey = Domain.medicationHistory;
		Medications medications = null;
		PatientIdentifier patientIdentifier = getPatientIdentifier();

		DateFilter dateFilter = DateFilterFactory.createFilterFromDate(startDate, endDate);

		Object cache = sessionStateHelper.checkCache(req.getSession(), cacheKey, dateFilter);
		if (cache != null && cache instanceof Medications) {
			LOGGER.debug("Using cached Medications for Medication History");
			medications = (Medications) cache;
		}

		if (medications == null) {
			LOGGER.debug("Fetching medications for Medication History from dataservice");
			try {
				MedicationDataService dataservice = new MedicationDataService();
				MedicationFilter filter = MedicationFilterFactory.createEmptyFilter();
				filter.setDateFilter(dateFilter);
				medications = dataservice.getPatientMedicationHistory(patientIdentifier, filter, ScopeFilter.getInstanceForLongitudinalScope());
				sessionStateHelper.addCacheMapToSession(req.getSession(), cacheKey, dateFilter, medications);
			} catch (Throwable t) {
				LOGGER.error(t);
				throw new RuntimeException(t);
			}
		}

		model.addAttribute("medications", medications);

		return "share/medicationhistory";

	}
}
