package com.agilex.healthcare.mbb.controller.share;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationFilter;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.SessionStateHelper;

@Controller
public class MedicationClinicalDomainController extends AbstractUserResource {
	protected static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(MedicationClinicalDomainController.class);

	@Resource SessionStateHelper sessionStateHelper;
	
	@RequestMapping(value = "/medication", method = RequestMethod.GET)
	public String getMedications(HttpServletRequest req, Model model) {
		String cacheKey = Domain.medication;
		Medications medications = null;
		PatientIdentifier patientIdentifier = getPatientIdentifier();

		Object cache = sessionStateHelper.checkCache(req.getSession(), cacheKey);
		if (cache != null && cache instanceof Medications) {
			LOGGER.debug("Using cached Medications");
			medications = (Medications) cache;
		}

		if (medications == null) {
			LOGGER.debug("Fetching medications from dataservice");
			try {
				MedicationDataService dataservice = new MedicationDataService();
				MedicationFilter filter = MedicationFilterFactory.createEmptyFilter();
				medications = dataservice.getActiveAndRecentlyExpiredPatientMedications(patientIdentifier, filter, ScopeFilter.getInstanceForLongitudinalScope());
				sessionStateHelper.addCacheMapToSession(req.getSession(), cacheKey, medications);
			} catch (Throwable t) {
				LOGGER.error(t);
				throw new RuntimeException(t);
			}
		}

		model.addAttribute("medications", medications);

		return "share/medications";

	}
}
