package com.agilex.healthcare.mbb.controller.share;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.ChemistryLabDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro.MicrobiologyLabDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.SessionStateHelper;

@Controller
public class LabTestDomainController extends AbstractUserResource {
	protected static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(LabTestDomainController.class);

	@Resource SessionStateHelper sessionStateHelper;
	
	@RequestMapping(value = "/lab-result", method = RequestMethod.GET)
	public String getLabs(HttpServletRequest req, Model model, @RequestParam String startDate, @RequestParam String endDate) {
		String cacheKey = Domain.labResult;
		DateFilter dateFilter = DateFilterFactory.createFilterFromDate(startDate, endDate);

		LabResults labResults = null;
		PatientIdentifier patientIdentifier = getPatientIdentifier();

		Object cache = sessionStateHelper.checkCache(req.getSession(), cacheKey, dateFilter);
		if (cache != null && cache instanceof LabResults) {
			LOGGER.debug("Using cached Lab Results");
			labResults = (LabResults) cache;
		}

		if (labResults == null) {
			ChemistryLabDataService dataservice = new ChemistryLabDataService();
			labResults = dataservice.getLabResults(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());
			
            // MBB-18: Microbiology Labs are not supported for veterans yet
//			MicrobiologyLabDataService microDataservice = new MicrobiologyLabDataService();
//			LabResults microLabResults = microDataservice.getLabResultsWithTextResults(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());
//			labResults.addAll(microLabResults);

			sessionStateHelper.addCacheMapToSession(req.getSession(), cacheKey, dateFilter, labResults);
		}
		
		model.addAttribute("labResults", labResults);

		return "share/labs";

	}
}
