package com.agilex.healthcare.mbb.controller.share;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.SessionStateHelper;

@Controller
public class DemographicsClinicalDomainController extends AbstractUserResource {
	protected static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(DemographicsClinicalDomainController.class);

	@Resource SessionStateHelper sessionStateHelper;
	
	@RequestMapping(value = "/demographic", method = RequestMethod.GET)
	public String getDemographics(HttpServletRequest req, Model model) {
		String demographicsCacheKey = Domain.demographic;
		String patientCacheKey = "patients";
		PatientIdentifier patientIdentifier = getPatientIdentifier();
		PatientDemographics demographics = null;
		Patient patient = null;
		PatientDataService dataservice = null;
		
		Object demographicsCache = sessionStateHelper.checkCache(req.getSession(), demographicsCacheKey);
		Object patientCache = sessionStateHelper.checkCache(req.getSession(), patientCacheKey);

		if (demographicsCache != null && demographicsCache instanceof PatientDemographics) {
			LOGGER.debug("Fetching demographics from cache");
			demographics = (PatientDemographics)demographicsCache;
		} 
		
		if (patientCache != null && patientCache instanceof Patient) {
			LOGGER.debug("Fetching patient from cache");
			patient = (Patient)patientCache;
		} 
		
		if (demographics == null || patient == null) {
			LOGGER.debug("Fetching demographics from dataservice");
			try {
				dataservice = new PatientDataService();

				demographics = dataservice.getPatientDemographics(patientIdentifier, ScopeFilter.getInstanceForLongitudinalScope());
				patient = MhpUserFactory.createFromSecurityContext().getPatient();

				sessionStateHelper.addCacheMapToSession(req.getSession(), demographicsCacheKey, demographics);
				sessionStateHelper.addCacheMapToSession(req.getSession(), patientCacheKey, patient);		
			} catch (Throwable t) {
				LOGGER.error(t);
				throw new RuntimeException(t);
			}
		}
		
		model.addAttribute("demographics", demographics);
		model.addAttribute("patient", patient);
		
		return "share/demographics";

	}
}
