package com.agilex.healthcare.mbb.controller.share;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.utils.SessionStateHelper;

@Controller
public class ClinicalAppointmentDomainController  extends AbstractUserResource {
	protected static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(ClinicalAppointmentDomainController.class);

	@Resource SessionStateHelper sessionStateHelper;
	
	@RequestMapping(value = "/appointment", method = RequestMethod.GET)
	public String getClinicalAppointments(HttpServletRequest req, Model model, @RequestParam String startDate, @RequestParam String endDate) {
		String cacheKey = Domain.appointment;
		Appointments appointments = null;
		PatientIdentifier patientIdentifier = getPatientIdentifier();
		DateFilter dateFilter = DateFilterFactory.createFilterFromDate(startDate, endDate);

		Object cache = sessionStateHelper.checkCache(req.getSession(), cacheKey, dateFilter);
		if (cache != null && cache instanceof Appointments) {
			LOGGER.debug("Using cached Appointments");
			appointments = (Appointments)cache;
		}
		
		if (appointments == null) {
			LOGGER.debug("Fetching appointments from dataservice");
			try {
				AppointmentDataService dataservice = new AppointmentDataService();
				appointments = dataservice.getPatientAppointmentsWithDetails(patientIdentifier, dateFilter);
				Appointments sortedAppointments = dataservice.sortByDate(appointments, true);
				sessionStateHelper.addCacheMapToSession(req.getSession(), cacheKey, dateFilter, sortedAppointments);
			} catch (Throwable t) {
				LOGGER.error(t);
				throw new RuntimeException(t);
			}
		}

		model.addAttribute("appointments", appointments);
		
		return "share/appointments";

	}
}
