package com.agilex.healthcare.mbb.controller.share;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.ChemistryLabDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.SessionStateHelper;

@Controller
public class ChemistryLabTestDomainController extends AbstractUserResource {
	protected static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(ChemistryLabTestDomainController.class);

	@Resource SessionStateHelper sessionStateHelper;
	
	@RequestMapping(value = "/lab-chemistry-result", method = RequestMethod.GET)
	public String getChemistryLabs(HttpServletRequest req, Model model, @RequestParam String startDate, @RequestParam String endDate) {
		String cacheKey = Domain.chemLabResult;
		DateFilter dateFilter = DateFilterFactory.createFilterFromDate(startDate, endDate);

		LabResults labResults = null;
		PatientIdentifier patientIdentifier = getPatientIdentifier();

		Object cache = sessionStateHelper.checkCache(req.getSession(), cacheKey, dateFilter);
		if (cache != null && cache instanceof LabResults) {
			LOGGER.debug("Using cached Chemistry Lab Results");
			labResults = (LabResults) cache;
		}

		if (labResults == null) {
			LOGGER.debug("Fetching chemistry lab results from dataservice");
			try {
				ChemistryLabDataService dataservice = new ChemistryLabDataService();
				labResults = dataservice.getLabResults(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());
				sessionStateHelper.addCacheMapToSession(req.getSession(), cacheKey, dateFilter, labResults);
			} catch (Throwable t) {
				LOGGER.error(t);
				throw new RuntimeException(t);
			}
		}

		model.addAttribute("labResults", labResults);

		return "share/labs";

	}
}
