package com.agilex.healthcare.mbb.controller.share;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.SessionStateHelper;

@Controller
public class AllergyClinicalDomainController extends AbstractUserResource {
	protected static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(AllergyClinicalDomainController.class);

	@Resource SessionStateHelper sessionStateHelper;
	
	@RequestMapping(value = "/allergy", method = RequestMethod.GET)
	public String getAllergiers(HttpServletRequest req, Model model) {
		String cacheKey = Domain.allergy;
		Allergies allergies = null;
		PatientIdentifier patientIdentifier = getPatientIdentifier();
		
		Object cache = sessionStateHelper.checkCache(req.getSession(), cacheKey);
		if (cache != null && cache instanceof Allergies) {
			LOGGER.debug("Using cached Allergies");
			allergies = (Allergies)cache;
		}
		
		if (allergies == null) {
			LOGGER.debug("Fetching allergies from dataservice");
			try {
				AllergyDataService dataService = new AllergyDataService();
				allergies = dataService.fetchPatientAllergies(patientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
				sessionStateHelper.addCacheMapToSession(req.getSession(), cacheKey, allergies);
			} catch (Exception e) {
				LOGGER.error(e);
				throw new RuntimeException(e);
			}
		}
		
		model.addAttribute("allergies", allergies);
		
		return "share/allergies";
	}
}
