package com.agilex.healthcare.mbb.controller.share;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.agilex.healthcare.mobilehealthplatform.datalayer.admission.AdmissionDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Admissions;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.restservice.AbstractUserResource;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.utils.SessionStateHelper;

@Controller
public class AdmissionsDomainController extends AbstractUserResource {
	protected static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(AdmissionsDomainController.class);

	@Resource SessionStateHelper sessionStateHelper;
	
	@RequestMapping(value = "/admission", method = RequestMethod.GET)
	public String getAdmissions(HttpServletRequest req, Model model, @RequestParam String startDate, @RequestParam String endDate) {
		String cacheKey = Domain.admission;
		Admissions admissions = null;
		PatientIdentifier patientIdentifier = getPatientIdentifier();
		DateFilter dateFilter = DateFilterFactory.createFilterFromDate(startDate, endDate);


		Object cache = sessionStateHelper.checkCache(req.getSession(), cacheKey, dateFilter);
		if (cache != null && cache instanceof Admissions) {
			LOGGER.debug("Using cached Admissions");
			admissions = (Admissions)cache;
		}
		
		if (admissions == null) {
			LOGGER.debug("Fetching admissions from dataservice");
			try {
				AdmissionDataService dataservice = new AdmissionDataService();
				admissions = dataservice.getPatientAdmissionsWithDetails(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());
				sessionStateHelper.addCacheMapToSession(req.getSession(), cacheKey, dateFilter, admissions);
			} catch (Throwable t) {
				LOGGER.error(t);
				throw new RuntimeException(t);
			}
		}

		model.addAttribute("admissions", admissions);

		return "share/admissions";
	}
}
