package com.agilex.healthcare.mobilehealthplatform.web;


import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.Assert;
import org.junit.Test;

import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import javax.annotation.Resource;

@RunWith(SpringJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration("classpath:applicationContext.xml")
public class LoginLogoutControllerTest extends SpringBasedIntegration {

    @Resource
    LoginLogoutController controller;

    @Test
    public void validRedirectUri() {
        Assert.assertTrue(controller.redirectUriIsPermitted("https://test-location.mobilehealth.domain/BrandNewService"));
//        Assert.assertTrue(controller.redirectUriIsPermitted("https://alternate.mobilehealth.domain"));
    }

    @Test
    public void validateBadRedirectUriFalse() {
        Assert.assertFalse(controller.redirectUriIsPermitted("http://google.com"));
        Assert.assertFalse(controller.redirectUriIsPermitted("http://malicious-entity.org"));
    }

    @Test
    public void validateNullOrEmptyRedirectUri() {
        Assert.assertFalse(controller.redirectUriIsPermitted(null));
        Assert.assertFalse(controller.redirectUriIsPermitted(""));
    }

}
