package com.agilex.healthcare.mobilehealthplatform.test;

import java.util.LinkedList;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.security.AppUser;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

/**
 * <p>
 * A base class helper to enable spring based integration tests. These settings
 * enable Junit to be Spring context Aware, so the Junit class itself can
 * consume any spring managed resource. It also makes all Junit classes to share the same Spring context (so applicationContext loads once and gets shared).
 * These features come from spring-test lib
 * </p>
 *
 * See the spring configuration file for more details on what configs will be loaded.
 *
 * @author Seena
 *
 */
public abstract class SpringBasedIntegration {
	private static final String USER_ID = "D123401";
	private static final String USERNAME = "zztest.patient01";
	private static final String PASSWORD = "pass";
	private static final String FIRST_NAME = "Gallow";
	private static final String LAST_NAME = "Younger";
	private static final String AUTHORITY = "EDIPI";

	@BeforeClass
	public static void init() throws Exception {
        MhpUser user = new MhpUser();
        user.setId(USER_ID);
		user.setFirstName(FIRST_NAME);
		user.setLastName(LAST_NAME);
		user.getPatient().setPatientIdentifier(getPatientIdentifier());
        AppUser appUser = new AppUser(USERNAME, PASSWORD, new LinkedList<GrantedAuthority>(), user);
        Authentication authentication = new TestingAuthenticationToken(appUser, null);

		SecurityContextHolder.getContext().setAuthentication(authentication);
	}

	public static PatientIdentifier getPatientIdentifier() {
		PatientIdentifier patientIdentifier = new PatientIdentifier();
		patientIdentifier.setUniqueId(USER_ID);
		patientIdentifier.setAssigningAuthority(AUTHORITY);
		return patientIdentifier;
	}

    @AfterClass
    public static void cleanup() {
        SecurityContextHolder.clearContext();
    }

}
