package com.agilex.healthcare.mobilehealthplatform.restservice;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class PatientDisplayNameTest {
	@Test
	public void validatePatientDisplayName() {
//		String searchcriteria = "younger,gallow";
		String searchcriteria = "patient01, zztest";
//		String expectedDisplayName = "younger, gallow";
		String expectedDisplayName = "patient01, zztest";
		// String expectedDisplayName = "younger, gallow openvista esq";
		runTest(searchcriteria, expectedDisplayName);
	}

	@Test
	public void validatePatientDisplayNameOnPatientWithoutMiddleName() {
		String searchcriteria = "patient09, zztest";
		String expectedDisplayName = searchcriteria;
		runTest(searchcriteria, expectedDisplayName);
	}

	private void runTest(String searchcriteria, String expectedDisplayName) {
		PatientDataService dataservice = new PatientDataService();
		Patients patients = dataservice.patientSearch(searchcriteria, "500", ScopeFilter.getInstanceForLongitudinalScope());
		assertTrue(patients.size() >= 1);
		Patient patient = patients.get(0);
		String displayName = patient.getDisplayName();
		assertEquals(expectedDisplayName.toLowerCase(), displayName.toLowerCase());
	}

}
