package com.agilex.healthcare.mobilehealthplatform.restservice;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import java.net.URI;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.GraphData;
import com.agilex.healthcare.mobilehealthplatform.domain.GraphDataSeries;
import com.agilex.healthcare.utility.DateHelper;

@Ignore
public class PainManagementGraphResourceTest {
	
	private PatientAssessmentsResource resource = null;
	private String patientId = "D123401";// GALLOW DATA
	private String assigningAuthority = "mock-aa";
	private UriInfo mockUriInfo = null;
	private HttpHeaders mockHttpHeaders = null;
	
	private UriInfo createMockUriInfo() {
		UriInfo mockUriInfo = mock(UriInfo.class);
		URI baseUri = UriBuilder.fromUri("http://server").build();
		when(mockUriInfo.getBaseUri()).thenReturn(baseUri);
		return mockUriInfo;
	}
	@Before
	public void setUp() throws Exception {
		resource = new PatientAssessmentsResource();
		mockUriInfo = createMockUriInfo();

		AssessmentDataHelper.createPreexistingMonthlyPainAssessments(patientId, assigningAuthority, mockUriInfo, mockHttpHeaders);
	}
	
	@Test
	public void canProducePainManagementGraphData(){
        String startDate = "01/01/2012";
        String endDate = "12/31/2012";
		resource = new PatientAssessmentsResource();
        GraphData graphData = resource.getPainManagementSummaryAsGraph(assigningAuthority, patientId, startDate, endDate, mockUriInfo, mockHttpHeaders);
		assertNotNull(graphData);
		assertEquals(2, graphData.getDataSeriesCollection().size());

		GraphDataSeries painDataSeries = graphData.getDataSeriesCollection().get(0);
		assertEquals(2, painDataSeries.size());

		GraphDataSeries assessmentSeries = graphData.getDataSeriesCollection().get(1);
		assertEquals(1, assessmentSeries.size());
	}

	@Test
	public void canProducePainManagementGraphDataWithDateFilterReturnsCorrectPainData(){
		resource = new PatientAssessmentsResource();
		GraphData graphData = resource.getPainManagementSummaryAsGraph(assigningAuthority, patientId, "08/21/2012", DateHelper.formatDate(DateHelper.getToday()), mockUriInfo, mockHttpHeaders);
		assertNotNull(graphData);
		assertEquals(2, graphData.getDataSeriesCollection().size());
		
		GraphDataSeries painDataSeries = graphData.getDataSeriesCollection().get(0);
		assertEquals(1, painDataSeries.size());
	}

	@Test
	public void canProducePainManagementGraphDataWithDateFilterReturnsNoAssessmentData(){
		resource = new PatientAssessmentsResource();
		GraphData graphData = resource.getPainManagementSummaryAsGraph(assigningAuthority, patientId, "08/21/2012", DateHelper.formatDate(DateHelper.getToday()), mockUriInfo, mockHttpHeaders);
		assertNotNull(graphData);
		assertEquals(2, graphData.getDataSeriesCollection().size());
		
		GraphDataSeries assessmentDataSeries = graphData.getDataSeriesCollection().get(1);
		assertEquals(0, assessmentDataSeries.size());
	}

	@Test
	public void canProducePainManagementGraphDataWithDateFilterReturnsAssessmentData(){
		resource = new PatientAssessmentsResource();
		GraphData graphData = resource.getPainManagementSummaryAsGraph(assigningAuthority, patientId, "06/01/2012", "06/02/2012", mockUriInfo, mockHttpHeaders);
		assertNotNull(graphData);
		assertEquals(2, graphData.getDataSeriesCollection().size());
		
		GraphDataSeries assessmentDataSeries = graphData.getDataSeriesCollection().get(1);
		assertEquals(1, assessmentDataSeries.size());
		
		
	}
}
