package com.agilex.healthcare.mobilehealthplatform.restservice;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import java.net.URI;
import java.net.URISyntaxException;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

import junit.framework.Assert;

import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.AtomLinks;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateRequest;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateRequests;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateStatusCode;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.utility.ModeHelper;

@Ignore
public class HealthAdvocateRequestResourceTest {

	private final static String assigningAuthority = "mock-aa";
	private final static String patientId = "D123401";
    private static HealthAdvocateRequest createdHealthAdvocateRequest;

	@BeforeClass
	public static void createNewHealthAdvocateRequest() {
        String mode = ModeHelper.getCurrentMode();

		UriInfo uriInfo = createMockUriInfo();
		createdHealthAdvocateRequest = createNewAdvocateRequest(uriInfo);
        assertNotNull(createdHealthAdvocateRequest);
	}

	@Test
	public void canCallFetchHealthAdvocateRequest() {
		UriInfo uriInfo = createMockUriInfo();
		HealthAdvocateRequests requests = getAdvocateRequests(uriInfo);
		assertNotNull(requests);
		Assert.assertNotSame(0, requests.size());
		HealthAdvocateRequest request = requests.get(0);
		assertNotNull(request);
        assertNotNull(request.getUniqueId());
		
		AtomLinks links = request.getLink();
		AtomLink detailLink = null;
		AtomLink revokedLink = null;
		AtomLink cancelledLink = null;
		
		for (AtomLink atomLink : links) {
			String linkTitle = atomLink.getTitle();
			if (LinkTitles.HealthAdvocateRequestFormDetail.equals(linkTitle)){
				detailLink = atomLink;
			}
			else if (LinkTitles.HealthAdvocateRequestRevokedFormDetail.equals(linkTitle)){
				revokedLink = atomLink;
			}
			else if (LinkTitles.HealthAdvocateRequestCancelledFormDetail.equals(linkTitle)){
				cancelledLink = atomLink;
			}
		}
		Assert.assertNotNull(detailLink);
		Assert.assertNotNull(revokedLink);
		Assert.assertNotNull(cancelledLink);
	}
	@Test
	public void canCallGetHealthAdvocateRequestForm() throws URISyntaxException{
		UriInfo uriInfo = createMockUriInfo();

		HttpHeaders httpHeaders = null;
		String systemId = "mock";
		String id = "1";
		String patientId = "D123401";
		
		HealthAdvocateRequestsResource resource = new HealthAdvocateRequestsResource();
		Response response = resource.getHealthAdvocateRequestForm(assigningAuthority, patientId, systemId, id, uriInfo, httpHeaders);	
		assertEquals(200, response.getStatus());
		assertNotNull(response);
	}

	@Test
	public void canCallGetHealthAdvocateRequestFormRevoked() throws URISyntaxException{
		UriInfo uriInfo = createMockUriInfo();

		HttpHeaders httpHeaders = null;
		String systemId = "mock";
		String id = "1";
		String patientId = "D123401";
		
		HealthAdvocateRequestsResource resource = new HealthAdvocateRequestsResource();
		Response response = resource.getHealthAdvocateRequestFormRevoked(assigningAuthority, patientId, systemId, id, uriInfo, httpHeaders);	
		assertEquals(200, response.getStatus());
		assertNotNull(response);
	}

	@Test
	public void canCallupdateHealthAdvocateRequest(){
		UriInfo uriInfo = createMockUriInfo();

		HttpHeaders httpHeaders = null;
		String systemId = "mock";
		String id = "1";
		String patientId = "D123401";
		
		HealthAdvocateRequestsResource resource = new HealthAdvocateRequestsResource();
		HealthAdvocateRequest request = createNewAdvocateRequest(uriInfo);
		request.setStatus(HealthAdvocateStatusCode.SUBMITTED);
		
		HealthAdvocateRequest updatedRequest = resource.updateHealthAdvocateRequest(request, assigningAuthority, patientId, systemId, id, uriInfo, httpHeaders);	
		assertNotNull(updatedRequest);
		assertEquals(HealthAdvocateStatusCode.SUBMITTED, updatedRequest.getStatus());
		
	}
	
    private HealthAdvocateRequests getAdvocateRequests(UriInfo uriInfo) {
		HttpHeaders httpHeaders = null;
		
		HealthAdvocateRequestsResource resource = new HealthAdvocateRequestsResource();
		HealthAdvocateRequests requests = resource.getHealthAdvocateRequests(assigningAuthority, patientId, uriInfo, httpHeaders);
		return requests;
	}

	private static HealthAdvocateRequest createNewAdvocateRequest(UriInfo uriInfo) {
		HealthAdvocateRequest request = new HealthAdvocateRequest();
        request.setEmail("email@email.com");
        request.setFirstName("firstName");
        request.setLastName("lastName");
        request.setAddressFirstLine("firstLineAddress");
        request.setAddressSecondLine("secondLineAddress");
        request.setCity("city");
        request.setDriversLicenseNumber("001");
        try {
            request.setFormDetailUri(new URI("http://blah.blah.com/blah"));
        } catch (URISyntaxException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
        request.setHealthAdvocateEDIPI("1234501");
        request.setPatientName("John Doe");
        request.setState("VA");
        request.setStatus("Requested");
        request.setZipCode("12345");

		HealthAdvocateRequest requestResult = null;
		HttpHeaders httpHeaders = null;
		
		HealthAdvocateRequestsResource resource = new HealthAdvocateRequestsResource();
		requestResult = resource.createNewHealthAdvocateRequest(request, assigningAuthority, patientId, uriInfo, httpHeaders);
		return requestResult;
	}

	private static UriInfo createMockUriInfo() {
		UriInfo mockUriInfo = mock(UriInfo.class);
		URI baseUri = UriBuilder.fromUri("http://server").build();
		when(mockUriInfo.getBaseUri()).thenReturn(baseUri);
		return mockUriInfo;
	}
}
