package com.agilex.healthcare.mobilehealthplatform.restservice;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.fail;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

@Ignore
public class ExtendedDataTest {

	private PatientResource resource = null;
	private PatientIdentifier youngerPatientIdentifier = new PatientIdentifier("aa", "D123401");
	private UriInfo mockUriInfo = null;
	private HttpHeaders mockHttpHeaders = null;

	@Before
	public void setUp() throws Exception {
		resource = new PatientResource();
	}

	@Test
	public void validateExtendedDataIsReturnedForValidPatient() {
		PatientDemographics extendedData = resource.getDemographics(youngerPatientIdentifier.getAssigningAuthority(), youngerPatientIdentifier.getUniqueId(), mockUriInfo, mockHttpHeaders);
		assertNotNull(extendedData);
	}

	@Ignore
	// @Test(expected = com.sun.jersey.api.NotFoundException.class)
	public void validateErrorThrownForInvalidPatient() {
		PatientIdentifier id = new PatientIdentifier("aa", "invalidpatient");
		resource.getDemographics(id.getAssigningAuthority(), id.getUniqueId(), mockUriInfo, mockHttpHeaders);
		fail("should error before getting here");
	}

	@Test
	public void validateNextOfKinDataIsReturnedForValidPatient() {
		PatientDemographics extendedData = resource.getDemographics(youngerPatientIdentifier.getAssigningAuthority(), youngerPatientIdentifier.getUniqueId(), mockUriInfo, mockHttpHeaders);
		assertNotNull(extendedData.getNextOfKin());
	}

	@Test
	public void validateCorrectNextOfKinDataIsReturnedForValidPatient() {
		String expectedNextOfKinName = "Younger, Mother";
		PatientDemographics demographics = resource.getDemographics(youngerPatientIdentifier.getAssigningAuthority(), youngerPatientIdentifier.getUniqueId(), mockUriInfo, mockHttpHeaders);
		assertEquals(expectedNextOfKinName, demographics.getNextOfKin().getName());

	}

	@Test
	public void validateNullIsReturnedForEmptyPatientId() {
		PatientIdentifier id = new PatientIdentifier("aa", "");
		PatientDemographics demographics = resource.getDemographics(id.getAssigningAuthority(), id.getUniqueId(), mockUriInfo, mockHttpHeaders);
		assertNull(demographics);

	}

	@Test
	public void validateNullIsReturnedForNullPatientId() {
		PatientIdentifier id = new PatientIdentifier("aa", null);
		PatientDemographics demographics = resource.getDemographics(id.getAssigningAuthority(), id.getUniqueId(), mockUriInfo, mockHttpHeaders);
		assertNull(demographics);

	}

	@Test
	public void validateCorrectNextOfKinDataIsReturnedForPatientPAT1() {
		PatientIdentifier id = new PatientIdentifier("aa", "PATID1");
		String expectedNextOfKinName = "Jones, Father";
		PatientDemographics demographics = resource.getDemographics(id.getAssigningAuthority(), id.getUniqueId(), mockUriInfo, mockHttpHeaders);
		assertEquals(expectedNextOfKinName, demographics.getNextOfKin().getName());

	}

}
