package com.agilex.healthcare.mobilehealthplatform.restservice;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import java.net.URI;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

import junit.framework.Assert;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Assessment;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentQuestion;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentQuestions;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResults;
import com.agilex.healthcare.mobilehealthplatform.domain.Assessments;


//TODO:  The methods to create a dummy assessment are largely duplicated in MonthlyPainReportGeneratorTest.  Refactor and consolidate.
public class AssessmentsDataTest {

	private PatientAssessmentsResource resource = null;
	private String patientIdWithNoPreviousAssessmentResult = "D123401";// GALLOW DATA
	private String patientIdWithPreviousAssessmentResult = "PATID26";// ALDIE DATA
	private String assigningAuthority = "EDIPI";
	private UriInfo mockUriInfo = null;
	private HttpHeaders mockHttpHeaders = null;
	

	@Before
	public void setUp() throws Exception {
		resource = new PatientAssessmentsResource();
		mockUriInfo = createMockUriInfo();

		AssessmentDataHelper.createPreexistingMonthlyPainAssessments(patientIdWithPreviousAssessmentResult, assigningAuthority, mockUriInfo, mockHttpHeaders);
	}

	@Test
	public void monthlyPainAssessmentHas12QuestionsWhenPreviousResultDoesNotExist(){

		Assessment assessment = resource.fetchAssessment("monthlyPain", patientIdWithNoPreviousAssessmentResult, assigningAuthority, mockUriInfo, mockHttpHeaders);
		assertNotNull(assessment);
		assertEquals("monthlyPain",  assessment.getId());
		
		AssessmentQuestions questions = assessment.getQuestions();
		assertEquals(12, questions.size());
		AssessmentQuestion question13 = assessment.getQuestionById("Q13");
		Assert.assertNull(question13);
	}

	//test same functionality, but using fetchAssessments()
	@Test
	public void fetchAssessmentsMonthlyPainAssessmentHas12QuestionsWhenPreviousResultDoesNotExist(){

//		Assessments assessments = resource.fetchAssessment("monthlyPain", patientIdWithNoPreviousAssessmentResult, assigningAuthority, mockUriInfo, mockHttpHeaders);
		Assessments assessments = resource.fetchAssessments(patientIdWithNoPreviousAssessmentResult, assigningAuthority, "monthlyPain", mockUriInfo, mockHttpHeaders);
		
		assertNotNull(assessments);
		assertEquals(1, assessments.size());
		
		Assessment assessment = assessments.get(0);
		assertNotNull(assessment);
		assertEquals("monthlyPain",  assessment.getId());
		
		AssessmentQuestions questions = assessment.getQuestions();
		assertEquals(12, questions.size());
		AssessmentQuestion question13 = assessment.getQuestionById("Q13");
		Assert.assertNull(question13);
	}

	@Test
	public void montlyPainAssessmentPreviousResultExists(){
		AssessmentResults assessments = resource.fetchAssessmentResults(patientIdWithPreviousAssessmentResult, assigningAuthority, "monthlyPain", mockUriInfo, mockHttpHeaders);
		assertNotNull(assessments);
		Assert.assertTrue(assessments.size() > 0);
	}

	@Test
	public void monthlyPainAssessmentHas13QuestionsWhenPreviousResultExists(){

		Assessment assessment = resource.fetchAssessment("monthlyPain", patientIdWithPreviousAssessmentResult, assigningAuthority, mockUriInfo, mockHttpHeaders);
		assertNotNull(assessment);
		assertEquals("monthlyPain",  assessment.getId());
		
		AssessmentQuestions questions = assessment.getQuestions();
		assertEquals(13, questions.size());
		AssessmentQuestion question13 = assessment.getQuestionById("Q13");
		Assert.assertNotNull(question13);
	}
	

	private UriInfo createMockUriInfo() {
		UriInfo mockUriInfo = mock(UriInfo.class);
		URI baseUri = UriBuilder.fromUri("http://server").build();
		when(mockUriInfo.getBaseUri()).thenReturn(baseUri);
		return mockUriInfo;
	}

}
