package com.agilex.healthcare.mobilehealthplatform.restservice;

import java.util.Date;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentProperties;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentProperty;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentQuestion;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentQuestionChoice;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentQuestionChoices;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResponse;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResponses;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResults;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssessmentCode;
import com.agilex.healthcare.utility.DateHelper;

public class AssessmentDataHelper {
	static void createPreexistingMonthlyPainAssessments(String patientId, String assigningAuthority, UriInfo mockUriInfo, HttpHeaders mockHttpHeaders) {
		PatientAssessmentsResource resource = new PatientAssessmentsResource();
		AssessmentResults results = resource.fetchAssessmentResults(patientId, assigningAuthority, "monthlyPain", mockUriInfo, mockHttpHeaders);

		if (results.size() == 0) {
			AssessmentResult preStageResult = generateMockAssessmentResult("monthlyPain", 2, null);
			preStageResult.setDateTaken(DateHelper.getYesterday());
			resource.saveAssessmentResult(patientId, assigningAuthority, preStageResult, mockUriInfo, mockHttpHeaders);
		}
	}

	static AssessmentResult generateMockAssessmentResult(String assessmentId, Integer... responsePointValues) {
		AssessmentResult mockResult = new AssessmentResult();
		mockResult.setAssessmentId(assessmentId);
		mockResult.setScoringAlgorithm(AssessmentCode.SCORING_ALGORITHM_UNSCORED);
		mockResult.setResponses(generateMockResponses(responsePointValues));
		Date today = DateHelper.getToday();
		mockResult.setDateTaken(today);
		int totalScore = 0;
		for (Integer responsePointValue : responsePointValues) {
			if (null != responsePointValue) {
				totalScore += responsePointValue.intValue();
			}
		}
		mockResult.setScore(totalScore);

        mockResult.setUniqueTitle("Test Title");
        mockResult.setVersion("0.1.2.3.4");
        mockResult.setAuthenticationStrategy("strict");
        mockResult.setWaitingPeriod(42);

		return mockResult;
	}

	static AssessmentResponses generateMockResponses(Integer... responsePointValues) {
		// generate in reverse order just so we can make sure the report
		// generates in correct order
		AssessmentResponses assessmentResponses = new AssessmentResponses();

		int questionNumber = 1;

		for (Integer responsePointValue : responsePointValues) {
			assessmentResponses = addResponse(assessmentResponses, responsePointValue, questionNumber);
			questionNumber++;
		}
		return assessmentResponses;
	}

	static AssessmentResponses addResponse(AssessmentResponses assessmentResponses, Integer pointValue, int questionNumber) {
		AssessmentResponse assessmentResponse = new AssessmentResponse();
		AssessmentQuestionChoices selectedChoices = new AssessmentQuestionChoices();
		AssessmentQuestionChoice selectedChoice = new AssessmentQuestionChoice();
		AssessmentProperties properties = new AssessmentProperties();
		AssessmentQuestion assessmentQuestion = new AssessmentQuestion();

		properties.add(new AssessmentProperty(AssessmentCode.RESULT_PROPERTY_SELECTED_VALUE, "" + pointValue));
		selectedChoice.setProperties(properties);
		selectedChoices.add(selectedChoice);
		assessmentResponse.setSelectedChoices(selectedChoices);

		assessmentQuestion.setQuestionNumber(questionNumber);
		assessmentQuestion.setId("Q" + questionNumber);
		assessmentResponse.setQuestion(assessmentQuestion);

		assessmentResponses.add(assessmentResponse);
		return assessmentResponses;
	}
}
