package com.agilex.healthcare.mbb.controller.soc;


import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.forwardedUrl;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.model;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.view;

import org.junit.*;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import com.agilex.healthcare.mobilehealthplatform.datalayer.admission.AdmissionDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Admission;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;

@Ignore // no longer in use
public class ClinicEventsDomainControllerTest extends SpringBasedIntegration {
	PatientIdentifier patientIdentifier = getPatientIdentifier();

	@Test
	public void testAppointment() throws Exception {
		Appointment appointment = getSourceAppointment();

		// MockMvcBuilders.xmlConfigSetup("classpath:applicationContext.xml").build()
		// 	.perform(get("/appointments/system/cdw/id/20"))
		// 	.andExpect(status().isOk())
		// 	.andExpect(forwardedUrl("soc/appointment"))
		// 	.andExpect(view().name("soc/appointment"))
		// 	.andExpect(model().attributeExists("appointment"))
		// 	.andExpect(model().attribute("appointment", appointment));
	}

	private Appointment getSourceAppointment() {
		AppointmentDataService appointmentDataService = new AppointmentDataService();
		final DataIdentifier dataIdentifier = new DataIdentifier("cdw", "20");
		Appointment appointment = appointmentDataService.getPatientAppointment(patientIdentifier, dataIdentifier);

		return appointment;
	}

	@Test
	public void testAdmission() throws Exception {
		Admission admission = getSourceAdmission();

		// MockMvcBuilders.xmlConfigSetup("classpath:applicationContext.xml").build()
		// 	.perform(get("/admissions/system/cdw/id/3"))
		// 	.andExpect(status().isOk())
		// 	.andExpect(forwardedUrl("soc/admission"))
		// 	.andExpect(view().name("soc/admission"))
		// 	.andExpect(model().attributeExists("admission"))
		// 	.andExpect(model().attribute("admission", admission));
	}

	private Admission getSourceAdmission() {
		AdmissionDataService admissionDataservice = new AdmissionDataService();
		final DataIdentifier dataIdentifier = new DataIdentifier("cdw", "3");
		Admission admission = admissionDataservice.getPatientAdmission(patientIdentifier, dataIdentifier);

		return admission;
	}
}
