package com.agilex.healthcare.mbb.controller.share;


import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.forwardedUrl;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.model;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.view;

import org.junit.Test;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.junit.Before;

import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalDataService;
import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalEntryFilter;
import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalsFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalTableData;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.MutableDateFilter;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.objectmapper.VitalTableDataGenerator;

@RunWith(SpringJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration("classpath:applicationContext.xml")
public class VitalsDomainControllerTest extends SpringBasedIntegration {
	PatientIdentifier patientIdentifier = getPatientIdentifier();

	String startDate = "11/11/2011";
	String endDate = "6/12/2012";

  @Autowired  private WebApplicationContext wac;
  private MockMvc mockMvc;

  @Before
  public void setup () {
    this.mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
  }

	@Test
	public void testController() throws Exception {
		VitalTableData vitals = getSourceVitalTableData();

		this.mockMvc
			.perform(get("/vitals").param("startDate", startDate).param("endDate", endDate))
			.andExpect(status().isOk())
			.andExpect(forwardedUrl("share/vitals"))
			.andExpect(view().name("share/vitals"))
			.andExpect(model().attributeExists("vitals"));
			//.andExpect(model().attribute("vitals", vitals));
	}

	private VitalTableData getSourceVitalTableData() {
		MutableDateFilter dateFilter = (MutableDateFilter) DateFilterFactory.createEmptyFilter();
		dateFilter.setStartDate(DateHelper.parseDate(startDate));
		dateFilter.setEndDate(DateHelper.parseDate(endDate));
		VitalEntryFilter filter = VitalsFilterFactory.createFilterFromDateFilter(dateFilter);

		VitalDataService dataservice = new VitalDataService();
		VitalEntries vitalEntries = dataservice.fetchVitalEntries(patientIdentifier, filter, ScopeFilter.getInstanceForLongitudinalScope());

		VitalTableDataGenerator tableGenerator = new VitalTableDataGenerator();
		VitalTableData vitalTableData = tableGenerator.generateVitalTableData(vitalEntries);
		vitalTableData.sortDescending("entryTime");

		return vitalTableData;
	}
}
