package com.agilex.healthcare.mbb.controller.share;


import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.forwardedUrl;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.model;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.view;

import org.junit.Test;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.junit.Before;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;

@RunWith(SpringJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration("classpath:applicationContext.xml")
public class DemographicsClinicalDomainControllerTest extends SpringBasedIntegration {
	PatientIdentifier patientIdentifier = getPatientIdentifier();

  @Autowired  private WebApplicationContext wac;
  private MockMvc mockMvc;

  @Before
  public void setup () {
    this.mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
  }

	@Test
	public void testController() throws Exception {
		PatientDataService dataservice = new PatientDataService();

		PatientDemographics demographics = getSourceDemographics(dataservice);
		Patient patient = getSourcePatient(dataservice);

		this.mockMvc
			.perform(get("/demographic"))
			.andExpect(status().isOk())
			.andExpect(forwardedUrl("share/demographics"))
			.andExpect(view().name("share/demographics"))
			.andExpect(model().attributeExists("demographics", "patient"));
			// TODO: I wasn't able to compare properly
			//.andExpect(model().attribute("patient", patient))
			//.andExpect(model().attribute("demographics", demographics));
	}

	private PatientDemographics getSourceDemographics(PatientDataService dataservice) {
		PatientDemographics demographics = dataservice.getPatientDemographics(patientIdentifier, ScopeFilter.getInstanceForLongitudinalScope());

		return demographics;
	}

	private Patient getSourcePatient(PatientDataService dataservice) {
		Patient patient = dataservice.getPatient(patientIdentifier, ScopeFilter.getInstanceForLongitudinalScope());

		return patient;
	}
}
