package com.agilex.healthcare.mbb.controller.share;


import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.forwardedUrl;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.model;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.view;

import org.junit.Test;
import org.junit.Ignore;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.junit.Before;

import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;

@Ignore("TODO: ensure data consistency with MAE CDW")
@RunWith(SpringJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration("classpath:applicationContext.xml")
public class AllergyClinicalDomainControllerTest extends SpringBasedIntegration {
	PatientIdentifier patientIdentifier = getPatientIdentifier();

  @Autowired  private WebApplicationContext wac;
  private MockMvc mockMvc;

  @Before
  public void setup () {
    this.mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
  }

	@Test
	public void testController() throws Exception {
		Allergies allergies = getSourceAllergies();

		this.mockMvc
			.perform(get("/allergy"))
			.andExpect(status().isOk())
			.andExpect(forwardedUrl("share/allergies"))
			.andExpect(view().name("share/allergies"))
			.andExpect(model().attributeExists("allergies"))
			.andExpect(model().attribute("allergies", allergies));
	}

	private Allergies getSourceAllergies() {
		AllergyDataService allergyDataservice = new AllergyDataService();
		Allergies allergies = allergyDataservice.fetchPatientAllergies(patientIdentifier, ScopeFilter.getInstanceForLongitudinalScope());

		return allergies;
	}
}
