package com.agilex.healthcare.mbb.controller;


import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.forwardedUrl;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.model;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.redirectedUrl;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.view;

import org.junit.Before;
import org.junit.Test;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;


import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.junit.Before;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;

@RunWith(SpringJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration("classpath:applicationContext.xml")
public class LoginLogoutControllerTest extends SpringBasedIntegration {
	PatientIdentifier patientIdentifier = getPatientIdentifier();

  @Autowired  private WebApplicationContext wac;
  private MockMvc mockMvc;

  @Before
  public void setup () {
    this.mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
  }

	@Test
	public void testLogin() throws Exception {
		this.mockMvc
			.perform(get("/login"))
			.andExpect(status().isOk())
			.andExpect(forwardedUrl("userLogin"))
			.andExpect(view().name("userLogin"));
	}

	@Test
	public void testDenied() throws Exception {
		this.mockMvc
			.perform(get("/denied"))
			.andExpect(status().isOk())
			.andExpect(forwardedUrl("userLogin"))
			.andExpect(view().name("userLogin"))
			.andExpect(model().attributeExists("error"))
			.andExpect(model().attribute("error", "You have entered an invalid username or password!"));
	}

	@Test
	public void testLogout() throws Exception {
		this.mockMvc
			.perform(get("/logout"))
			.andExpect(status().isFound())
			.andExpect(redirectedUrl("http://localhost:8080/ssoeproxy/logout?filename=mbb-logout.html"));
	}
}
