package com.agilex.healthcare.mobilehealthplatform.oauth;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class Oauth2AccessTokenReaderTest {

	private MockHttpServletRequest request;

	@Test
	public void validateReadingOfTokenFromHttpRequest() {
		Oauth2AccessTokenReader reader = new Oauth2AccessTokenReader();
		
		String expectedToken = "234sjhdfg";
		request = new MockHttpServletRequest();
		request.addHeader("Authorization", "Bearer " + expectedToken);
		String actualToken = reader.readTokenFromHttpRequest(request);
		
		assertEquals(expectedToken, actualToken);
	}
	

	@Test
	public void validateReadingOfTokenFromHttpRequestWithCapitalBEARER() {
		Oauth2AccessTokenReader reader = new Oauth2AccessTokenReader();
		
		String expectedToken = "234sjhdfg";
		request = new MockHttpServletRequest();
		request.addHeader("Authorization", "BEARER " + expectedToken);
		String actualToken = reader.readTokenFromHttpRequest(request);
		
		assertEquals(expectedToken, actualToken);
	}
	
	@Test
	public void validateWhenAuthorizationHeaderIsNotPresent() {
		Oauth2AccessTokenReader reader = new Oauth2AccessTokenReader();
		
		request = new MockHttpServletRequest();
		String actualToken = reader.readTokenFromHttpRequest(request);
		
		assertNull(actualToken);
	}
	
	
}
