package com.agilex.healthcare.mobilehealthplatform.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.Namespace;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "authentication", namespace = Namespace.MobileHealthPlatform)
public class HAOauth2Authentication implements Serializable{
	
	private static final long serialVersionUID = -3030518789018551778L;

	@XmlElement	
	private List<String> authorities;
	@XmlElement
	private MhpUser mhpUser;
	@XmlElement
	private String userName;
	@XmlElement
	private ClientAuthorizationRequest authorizatioRequest;
	@XmlElement
	private Date lastLoginDate;
	
	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}
	
	public List<String> getAuthorities() {
		return authorities;
	}
	
	public void setAuthorities(List<String> authorities) {
		this.authorities = authorities;
	}
	public MhpUser getMhpUser() {
		return mhpUser;
	}
	public void setMhpUser(MhpUser mhpUser) {
		this.mhpUser = mhpUser;
	}
	public ClientAuthorizationRequest getAuthorizatioRequest() {
		return authorizatioRequest;
	}
	public void setAuthorizatioRequest(ClientAuthorizationRequest authorizatioRequest) {
		this.authorizatioRequest = authorizatioRequest;
	}

	public Date getLastLoginDate() {
		return lastLoginDate;
	}

	public void setLastLoginDate(Date lastLoginDate) {
		this.lastLoginDate = lastLoginDate;
	}
}
