package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import static com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriTester.validateUriAreEqual;

import java.net.URI;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResult;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyTest;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyTests;

public class RadiologyTestLinkBuilderTest extends AbstractLinkBuilderTest<RadiologyTests, RadiologyTest> {

	@Override
	protected RadiologyTests createEmtpyDtoList() {
		return new RadiologyTests();
	}

	@Override
	protected RadiologyTest createEmptyDto() {
		return new RadiologyTest();
	}

	@Override
	protected PatientDataLinkBuilder<RadiologyTests, RadiologyTest> getPatientDataLinkBuilder(URI baseUri) {
		return new RadiologyTestsLinkBuilder(baseUri);
	}

	@Override
	protected String getExpectedUriForDtoWithId123() {
		return null;
	}

	@Test
	public void resultsLinks() {
		PatientIdentifier patientIdentifier = new PatientIdentifier("aa", "patid");

		RadiologyTest radTest = new RadiologyTest();
		radTest.setDataIdentifier("", "rad-test-id");
		radTest.setPatientIdentifier(patientIdentifier);

		RadiologyResult radResultA = new RadiologyResult();
		radResultA.setDataIdentifier("s", "rad-result-A");
		radResultA.setPatientIdentifier(patientIdentifier);
		radTest.getRadiologyResults().add(radResultA);

		RadiologyResult radResultB = new RadiologyResult();
		radResultB.setDataIdentifier("s", "rad-result-B");
		radResultB.setPatientIdentifier(patientIdentifier);
		radTest.getRadiologyResults().add(radResultB);

		RadiologyResult radResultMostRecent = new RadiologyResult();
		radResultMostRecent.setDataIdentifier("s", "rad-result-A");
		radResultMostRecent.setPatientIdentifier(patientIdentifier);
		radTest.setMostRecentRadiologyResult(radResultMostRecent);

		RadiologyTestsLinkBuilder linkBuilder = new RadiologyTestsLinkBuilder(super.baseUri);
		linkBuilder.fillLinks(radTest, null);

		validateUriAreEqual("http://server/patient/aa/patid/radiology/results/system/s/id/rad-result-A", radTest.getMostRecentRadiologyResult().getSelfUri());

		validateUriAreEqual("http://server/patient/aa/patid/radiology/results/system/s/id/rad-result-A", radTest.getRadiologyResults().get(0).getSelfUri());
		validateUriAreEqual("http://server/patient/aa/patid/radiology/results/system/s/id/rad-result-B", radTest.getRadiologyResults().get(1).getSelfUri());
	}

}
