package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriHelper;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriTester;

public class PatientLinkBuilderTest {
	Patient patientWithLinks = initializeAndFillLinksForPatient();

	@Test
	public void containsSelfLink() {
		checkSelfLink("http://server/base/patient/1.1/1");
	}

	@Test
	public void containsAllergiesLink() {
		checkLink(LinkTitles.PatientAllergies, "http://server/base/patient/1.1/1/allergies/scope/longitudinal");
	}
	
	@Test
	public void containsAllergiesLongitudinalLink() {
		checkLink(LinkTitles.PatientAllergies+"-longitudinal", "http://server/base/patient/1.1/1/allergies/scope/longitudinal");
	}
	
	@Test
	public void containsAllergiesOperationalLink() {
		checkLink(LinkTitles.PatientAllergies+"-operational", "http://server/base/patient/1.1/1/allergies/scope/operational");
	}

	@Test
	public void containsProblemsLink() {
		checkLink(LinkTitles.PatientProblems, "http://server/base/patient/1.1/1/problems/scope/longitudinal");
	}
	
	@Test
	public void containsProblemsLongitudinalLink() {
		checkLink(LinkTitles.PatientProblemsLongitudinal, "http://server/base/patient/1.1/1/problems/scope/longitudinal");
	}
	
	@Test
	public void containsProblemsOperationalLink() {
		checkLink(LinkTitles.PatientProblemsOperational, "http://server/base/patient/1.1/1/problems/scope/operational");
	}

	@Test
	public void containsDemoraphicsLink() {
		checkLink(LinkTitles.PatientDemographics, "http://server/base/patient/1.1/1/demographics/scope/longitudinal");
	}

	@Test
	public void containsDemoraphicsLongitudinalLink() {
		checkLink(LinkTitles.PatientDemographics+"-longitudinal", "http://server/base/patient/1.1/1/demographics/scope/longitudinal");
	}
	
	@Test
	public void containsDemoraphicsOperationalLink() {
		checkLink(LinkTitles.PatientDemographics+"-operational", "http://server/base/patient/1.1/1/demographics/scope/operational");
	}
	
	@Test
	public void containsDocumentsLink() {
		checkLink(LinkTitles.PatientDocuments, "http://server/base/patient/1.1/1/documents");
	}

	@Test
	public void containsImageLink() {
		checkLink(LinkTitles.PatientImage, "http://server/base/patient/1.1/1/patient-image");
	}

	@Test
	public void containsMedicationsLink() {
		checkLink(LinkTitles.PatientMedications, "http://server/base/patient/1.1/1/medications/scope/longitudinal");
	}

	@Test
	public void containsActiveMedicationsLink() {
		checkLink(LinkTitles.PatientActiveMedications, "http://server/base/patient/1.1/1/medications/active");
	}

	@Test
	public void containsOutpatientMedicationsLink() {
		checkLink(LinkTitles.PatientOutpatientMedications, "http://server/base/patient/1.1/1/medications/outpatient/scope/longitudinal");
	}

	@Test
	public void containsActiveOutpatientMedicationsLink() {
		checkLink(LinkTitles.PatientActiveOutpatientMedications, "http://server/base/patient/1.1/1/medications/outpatient/active");
	}

	@Test
	public void containsActiveInpatientMedicationsLink() {
		checkLink(LinkTitles.PatientActiveInpatientMedications, "http://server/base/patient/1.1/1/medications/inpatient/active");
	}

	@Test
	public void containsInpatientMedicationsLink() {
		checkLink(LinkTitles.PatientInpatientMedications, "http://server/base/patient/1.1/1/medications/inpatient/scope/longitudinal");
	}

	@Test
	public void containsLabResultsLink() {
		checkLink(LinkTitles.PatientChemistryLabResults, "http://server/base/patient/1.1/1/lab/results/scope/longitudinal");
	}

	@Test
	public void containsLabTestLink() {
		checkLink(LinkTitles.PatientChemistryLabTestHistory, "http://server/base/patient/1.1/1/lab/tests/scope/longitudinal");
	}

	@Test
	public void containsLabTestHistoryByGroupLink() {
		checkLink(LinkTitles.PatientChemistryLabTestHistoryByGroup, "http://server/base/patient/1.1/1/lab/groups/scope/longitudinal");
	}

	@Test
	public void containsMicroLabResultsLink() {
		checkLink(LinkTitles.PatientMicrobiologyLabResults, "http://server/base/patient/1.1/1/lab-microbiology/results/scope/longitudinal");
	}

	@Test
	public void containsMicroLabTestLink() {
		checkLink(LinkTitles.PatientMicrobiologyLabTestHistory, "http://server/base/patient/1.1/1/lab-microbiology/tests/scope/longitudinal");
	}

	@Test
	public void containsMicroLabTestHistoryByGroupLink() {
		checkLink(LinkTitles.PatientMicrobiologyLabTestHistoryByGroup, "http://server/base/patient/1.1/1/lab-microbiology/groups/scope/longitudinal");
	}

	@Test
	public void containsLongitudinalVitals() {
		checkLink(LinkTitles.PatientVitalsLongitudinal, "http://server/base/patient/1.1/1/vitals/scope/longitudinal");
	}

	@Test
	public void containsOperationalVitals() {
		checkLink(LinkTitles.PatientVitalsOperational, "http://server/base/patient/1.1/1/vitals/scope/operational");
	}

	@Test
	public void containsLongitudinalVitalsInGraphFormat() {
		checkLink(LinkTitles.PatientVitalsGraphLongitudinal, "http://server/base/patient/1.1/1/vitals/scope/longitudinal/graphdata");
	}

	@Test
	public void containsOperationalVitalsInGraphFormat() {
		checkLink(LinkTitles.PatientVitalsGraphOperational, "http://server/base/patient/1.1/1/vitals/scope/operational/graphdata");
	}

	@Test
	public void containsLongitudinalVitalsInTableFormat() {
		checkLink(LinkTitles.PatientVitalsTableLongitudinal, "http://server/base/patient/1.1/1/vitals/scope/longitudinal/tabledata");
	}

	@Test
	public void containsOperationalVitalsInTableFormat() {
		checkLink(LinkTitles.PatientVitalsTableOperational, "http://server/base/patient/1.1/1/vitals/scope/operational/tabledata");
	}

	@Test
	public void containsPatientEnteredHeightVitalsLink() {
		checkLink(LinkTitles.PatientEnteredVitalsHeight, "http://server/base/patient/1.1/1/patient-entered-vitals?section=height");
	}

	@Test
	public void containsPatientEnteredWeightVitalsLink() {
		checkLink(LinkTitles.PatientEnteredVitalsWeight, "http://server/base/patient/1.1/1/patient-entered-vitals?section=weight");
	}

	@Test
	public void containsPatientEnteredPainLink() {
		checkLink(LinkTitles.PatientEnteredVitalsPain, "http://server/base/patient/1.1/1/patient-entered-vitals?section=pain");
	}

	@Test
	public void containsPatientEnteredRespirationLink() {
		checkLink(LinkTitles.PatientEnteredVitalsRespiration, "http://server/base/patient/1.1/1/patient-entered-vitals?section=respiration");
	}

	@Test
	public void containsPatientEnteredTemperatureLink() {
		checkLink(LinkTitles.PatientEnteredVitalsTemperature, "http://server/base/patient/1.1/1/patient-entered-vitals?section=temperature");
	}

	@Test
	public void containsMoodLink() {
		checkLink(LinkTitles.PatientMood, "http://server/base/patient/1.1/1/mood");
	}

	@Test
	public void containsExerciseLink() {
		checkLink(LinkTitles.PatientExercise, "http://server/base/patient/1.1/1/exercise");
	}

	@Test
	public void containsDietLink() {
		checkLink(LinkTitles.PatientDiet, "http://server/base/patient/1.1/1/diet");
	}

	@Test
	public void containsContactLogsLink() {
		checkLink(LinkTitles.PatientContactLogs, "http://server/base/patient/1.1/1/contactLogs");
	}

	@Test
	public void containsDailyEventsLink() {
		checkLink(LinkTitles.DailyEvents, "http://server/base/patient/1.1/1/dailyevents");
	}

	@Test
	public void containsSurgeriesLink() {
		checkLink(LinkTitles.PatientSurgeries, "http://server/base/patient/1.1/1/surgeries/scope/longitudinal");
	}
	
	@Test
	public void containsSurgeriesLongitudinalLink() {
		checkLink(LinkTitles.PatientSurgeries+"-longitudinal", "http://server/base/patient/1.1/1/surgeries/scope/longitudinal");
	}
	
	@Test
	public void containsSurgeriesOperationalLink() {
		checkLink(LinkTitles.PatientSurgeries+"-operational", "http://server/base/patient/1.1/1/surgeries/scope/operational");
	}

	@Test
	public void containsAppointmentsLink() {
		checkLink(LinkTitles.PatientAppointments, "http://server/base/patient/1.1/1/appointments/scope/longitudinal");
	}
	
	@Test
	public void containsAppointmentsLongitudinalLink() {
		checkLink(LinkTitles.PatientAppointmentsLongitudinal, "http://server/base/patient/1.1/1/appointments/scope/longitudinal");
	}
	
	@Test
	public void containsAppointmentsOperationalLink() {
		checkLink(LinkTitles.PatientAppointmentsOperational, "http://server/base/patient/1.1/1/appointments/scope/operational");
	}
	
	@Test
	public void containsMentalHealthAppointmentsLongitudinalLink() {
		checkLink(LinkTitles.PatientMentalHealthAppointments + "-longitudinal", "http://server/base/patient/1.1/1/appointments/mental-health/scope/longitudinal");
	}
	
	@Test
	public void containsMentalHealthAppointmentsOperationalLink() {
		checkLink(LinkTitles.PatientMentalHealthAppointments + "-operational", "http://server/base/patient/1.1/1/appointments/mental-health/scope/operational");
	}

	@Test
	public void containsAdmissionsLink() {
		checkLink(LinkTitles.PatientAdmissions, "http://server/base/patient/1.1/1/admissions/scope/longitudinal");
	}
	
	@Test
	public void containsAdmissionsLongitudinalLink() {
		checkLink(LinkTitles.PatientAdmissions+"-longitudinal", "http://server/base/patient/1.1/1/admissions/scope/longitudinal");
	}
	
	@Test
	public void containsAdmissionsOperationalLink() {
		checkLink(LinkTitles.PatientAdmissions+"-operational", "http://server/base/patient/1.1/1/admissions/scope/operational");
	}

	@Test
	public void containsPastAppointmentsLink() {
		checkLink(LinkTitles.PatientPastAppointments, "http://server/base/patient/1.1/1/appointments/past");
	}

	@Test
	public void containsRadiologyResultsLink() {
		checkLink(LinkTitles.PatientRadiologyResults, "http://server/base/patient/1.1/1/radiology/results/scope/longitudinal");
	}
	
	@Test
	public void containsRadiologyResultsLongitudinalLink() {
		checkLink(LinkTitles.PatientRadiologyResults + "-longitudinal", "http://server/base/patient/1.1/1/radiology/results/scope/longitudinal");
	}
	
	@Test
	public void containsRadiologyResultsOperationalLink() {
		checkLink(LinkTitles.PatientRadiologyResults+ "-operational", "http://server/base/patient/1.1/1/radiology/results/scope/operational");
	}

	@Test
	public void containsRadiologyTestLink() {
		checkLink(LinkTitles.PatientRadiologyTests, "http://server/base/patient/1.1/1/radiology/tests/scope/longitudinal");
	}
	
	@Test
	public void containsRadiologyTestLongitudinalLink() {
		checkLink(LinkTitles.PatientRadiologyTests+"-longitudinal", "http://server/base/patient/1.1/1/radiology/tests/scope/longitudinal");
	}
	
	@Test
	public void containsRadiologyTestOperationalLink() {
		checkLink(LinkTitles.PatientRadiologyTests+"-operational", "http://server/base/patient/1.1/1/radiology/tests/scope/operational");
	}

	@Test
	public void containsMyGoalsInventoryLink() {
		checkLink(LinkTitles.MyGoalsInventory, "http://server/base/patient/1.1/1/mygoals");
	}
	
	private void checkSelfLink(String expected) {
		UriTester.validateUriAreEqual(expected, patientWithLinks.getSelfUri());
	}

	private void checkLink(String linkTitle, String expected) {
		UriTester.validateUriAreEqualUsingLinkTitle(patientWithLinks, linkTitle, expected);
	}

	private Patient initializeAndFillLinksForPatient() {
		Patient patient = new Patient();
		patient.getPatientIdentifier().setUniqueId("1");
		patient.getPatientIdentifier().setAssigningAuthority("1.1");

		// PatientUriHelper.updatePatientLinks(patient,
		// UriHelper.createUri("http://server/base/"));

		URI baseUri = UriHelper.createUri("http://server/base");
		PatientLinkBuilder builder = new PatientLinkBuilder(baseUri);
		builder.fillLinks(patient, null);

		return patient;
	}
}
