package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.LabTest;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTests;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriTester;

public class MicrobiologyLabTestLinkBuilderTest extends AbstractLinkBuilderTest<LabTests, LabTest> {

	@Override
	protected LabTests createEmtpyDtoList() {
		return new LabTests();
	}

	@Override
	protected LabTest createEmptyDto() {
		return new LabTest();
	}

	@Override
	protected PatientDataLinkBuilder<LabTests, LabTest> getPatientDataLinkBuilder(URI baseUri) {
		return new MicrobiologyLabTestLinkBuilder(baseUri);
	}

	@Override
	protected String getExpectedUriForDtoWithId123() {
		return null;
	}

	@Test
	public void validateResultsUri() {
		String expectedUri = "http://server/patient/a/p/lab-microbiology/results?test-id=123";
		LabTest labTest = createLabTest();

		MicrobiologyLabTestLinkBuilder builder = new MicrobiologyLabTestLinkBuilder(baseUri);
		builder.fillLinks(labTest, null);

		UriTester.validateUriAreEqualUsingLinkTitle(labTest, LinkTitles.PatientMicrobiologyLabResultsForTest, expectedUri);
	}

	private LabTest createLabTest() {
		LabTest labTest = new LabTest();
		labTest.setPatientIdentifier("a", "p");
		labTest.setUniqueId("123");
		return labTest;
	}

	@Test
	public void validateResultsUriWithSpecimen() {
		String expectedUri = "http://server/patient/a/p/lab-microbiology/results?test-id=123&specimenId=s";

		LabTest labTest = createLabTest();
		labTest.setSpecimenId("s");

		MicrobiologyLabTestLinkBuilder builder = new MicrobiologyLabTestLinkBuilder(baseUri);
		builder.fillLinks(labTest, null);

		UriTester.validateUriAreEqualUsingLinkTitle(labTest, LinkTitles.PatientMicrobiologyLabResultsForTest, expectedUri);
	}

}
