package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import junit.framework.Assert;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriTester;

public class MedicationLinkBuilderTest extends AbstractLinkBuilderTest<Medications, Medication> {

	@Override
	protected Medications createEmtpyDtoList() {
		return new Medications();
	}

	@Override
	protected Medication createEmptyDto() {
		Medication medication = new Medication();
		medication.setOrderNumber("ON123");
		medication.setUniqueId("123");
		return medication;
	}

	@Override
	protected PatientDataLinkBuilder<Medications, Medication> getPatientDataLinkBuilder(URI baseUri) {
		return new MedicationLinkBuilder(baseUri);
	}
	
	@Test
	public void validateResponseWithNullId() {
		Medication medication = new Medication();
		
		MedicationLinkBuilder builder = new MedicationLinkBuilder(baseUri);
		builder.fillCustomRelatedLinks(medication);
		
		Assert.assertNull(medication.getSelfUri());
	}

	@Override
	protected String getExpectedUriForDtoWithId123() {
		return "http://server/patient/a/p/medications/system/c/id/123";
	}

	@Test
	public void validateRelatedLinkForDetails() {
		UriTester.validateUriAreEqualUsingLinkTitle(this.dto, LinkTitles.PatientMedicationDetail, "http://server/patient/a/p/medications/system/c/id/123");
	}

}
