package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.domain.LabTest;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTests;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriTester;

public class ChemistryLabTestLinkBuilderTest extends AbstractLinkBuilderTest<LabTests, LabTest> {

	@Override
	protected LabTests createEmtpyDtoList() {
		return new LabTests();
	}

	@Override
	protected LabTest createEmptyDto() {
		return new LabTest();
	}

	@Override
	protected PatientDataLinkBuilder<LabTests, LabTest> getPatientDataLinkBuilder(URI baseUri) {
		return new ChemistryLabTestLinkBuilder(baseUri);
	}

	@Override
	protected String getExpectedUriForDtoWithId123() {
		return null;
	}

	@Test
	public void validateResultsUriForLoinc() {
		String expectedUri = "http://server/patient/a/p/lab/results/system/systemIdGoesHere?loinc-code=123";

		LabTest labTest = createLabTest();
		labTest.setDataIdentifier("systemIdGoesHere", "123");
		labTest.setLoinc("123");

		ChemistryLabTestLinkBuilder builder = new ChemistryLabTestLinkBuilder(baseUri);
		builder.fillLinks(labTest, null);

		UriTester.validateUriAreEqualUsingLinkTitle(labTest, LinkTitles.PatientChemistryLabResultsForTest, expectedUri);
	}
	
	@Test
	public void validateResultsUriForTestAndSpecimen() {
		String expectedUri = "http://server/patient/a/p/lab/results/system/systemIdGoesHere?test=123&specimen=BLOOD";

		LabTest labTest = createLabTest();
		labTest.setDataIdentifier("systemIdGoesHere", "123");
		labTest.setSpecimenName("BLOOD");

		ChemistryLabTestLinkBuilder builder = new ChemistryLabTestLinkBuilder(baseUri);
		builder.fillLinks(labTest, null);

		UriTester.validateUriAreEqualUsingLinkTitle(labTest, LinkTitles.PatientChemistryLabResultsForTest, expectedUri);
	}

	private LabTest createLabTest() {
		LabTest labTest = new LabTest();
		labTest.setPatientIdentifier("a", "p");
		labTest.setUniqueId("123");
		return labTest;
	}

}
