package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import java.net.URI;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriTester;

public class ChemistryLabResultLinkBuilderTest extends AbstractLinkBuilderTest<LabResults, LabResult> {

	@Override
	protected LabResults createEmtpyDtoList() {
		return new LabResults();
	}

	@Override
	protected LabResult createEmptyDto() {
		return new LabResult();
	}

	@Override
	protected PatientDataLinkBuilder<LabResults, LabResult> getPatientDataLinkBuilder(URI baseUri) {
		return new ChemistryLabResultLinkBuilder(baseUri);
	}

	@Override
	protected String getExpectedUriForDtoWithId123() {
		return null;
	}

	@Test
	public void validateResultsUriForLoinc() {
		String expectedUri = "http://server/patient/a/p/lab/results/system/systemIdGoesHere?loinc-code=123";

		LabResult labResult = createLabTest();
		labResult.setDataIdentifier("systemIdGoesHere", "123");
		labResult.setLoinc("123");

		ChemistryLabResultLinkBuilder builder = new ChemistryLabResultLinkBuilder(baseUri);
		builder.fillLinks(labResult, null);

		UriTester.validateUriAreEqualUsingLinkTitle(labResult, LinkTitles.PatientChemistryLabResultsForTest, expectedUri);
	}


	@Test
	public void validateResultsUriForTestAndSpecimen() {
		String expectedUri = "http://server/patient/a/p/lab/results/system/systemIdGoesHere?test=345&specimen=BLOOD";

		LabResult labResult = createLabTest();
		labResult.setDataIdentifier("systemIdGoesHere", "123");
		labResult.setTestId("345");
		labResult.setSpecimenName("BLOOD");

		ChemistryLabResultLinkBuilder builder = new ChemistryLabResultLinkBuilder(baseUri);
		builder.fillLinks(labResult, null);

		UriTester.validateUriAreEqualUsingLinkTitle(labResult, LinkTitles.PatientChemistryLabResultsForTest, expectedUri);
	}

	
	private LabResult createLabTest() {
		LabResult labResult = new LabResult();
		labResult.setPatientIdentifier("a", "p");
		labResult.setUniqueId("123");
		return labResult;
	}

}
