package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.linkbuilder;

import static com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriTester.validateUriAreEqual;
import static org.junit.Assert.fail;

import java.net.URI;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDataCollection;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.utils.uriformaters.UriHelper;

public abstract class AbstractLinkBuilderTest<Ts extends PatientDataCollection<T>, T extends PatientData> {

	final protected URI baseUri = UriHelper.createUri("http://server");
	final protected URI requestUri = UriHelper.createUri("http://server/request");
	protected final T dto = initializeAndFillLinkForDto();

	@Test
	public void createLinksForDtoListWithoutRequest() {
		Ts dtoList = createTestDtoList();

		PatientDataLinkBuilder<Ts, T> linkBuilder = getPatientDataLinkBuilder();
		linkBuilder.fillLinks(dtoList, null);

		validateUriAreEqual("", dtoList.getSelfUri());
	}

	@Test
	public void createLinksForDtoListWithRequest() {
		Ts dtoList = createTestDtoList();

		PatientDataLinkBuilder<Ts, T> linkBuilder = getPatientDataLinkBuilder();
		linkBuilder.fillLinks(dtoList, requestUri);

		validateUriAreEqual(requestUri, dtoList.getSelfUri());
	}

	@Test(expected = IllegalArgumentException.class)
	public void createLinksForDtoListWithoutBaseUri() {
		Ts dtoList = createTestDtoList();

		PatientDataLinkBuilder<Ts, T> linkBuilder = getPatientDataLinkBuilder(null);
		linkBuilder.fillLinks(dtoList, requestUri);

		fail("Should have failed with IllegalArgumentException");
	}

	@Test
	public void createLinksForDto() {
		validateUriAreEqual(this.getExpectedUriForDtoWithId123(), dto.getSelfUri());
	}

	private T initializeAndFillLinkForDto() {
		T dto = createDto("a", "p", "c", "123");

		PatientDataLinkBuilder<Ts, T> linkBuilder = getPatientDataLinkBuilder();
		linkBuilder.fillLinks(dto, null);
		return dto;
	}

	private Ts createTestDtoList() {
		Ts dtoList = createEmtpyDtoList();
		dtoList.add(createDto("a", "p", "c", "123"));
		dtoList.add(createDto("a", "p", "c", "456"));
		dtoList.add(createDto("a", "p", "c", "789"));
		dtoList.updatePatientIdentifier(new PatientIdentifier("a", "p"));
		return dtoList;
	}

	private T createDto(String assigningAuthority, String patientId, String community, String uniqueId) {
		T item = createEmptyDto();
		item.setDataIdentifier(community, uniqueId);
		item.setPatientIdentifier(assigningAuthority, patientId);
		return item;
	}

	protected abstract Ts createEmtpyDtoList();

	protected abstract T createEmptyDto();

	private PatientDataLinkBuilder<Ts, T> getPatientDataLinkBuilder() {
		return this.getPatientDataLinkBuilder(this.baseUri);
	}

	protected abstract PatientDataLinkBuilder<Ts, T> getPatientDataLinkBuilder(URI baseUri);

	protected abstract String getExpectedUriForDtoWithId123();

}
