package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters;

import static org.junit.Assert.assertEquals;

import java.net.URI;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;

public class UriTester {
	public static void validateUriAreEqual(String expected, URI actual) {
		validateUriAreEqual(serialize(expected), serialize(actual));
	}

	public static void validateUriAreEqual(URI expected, String actual) {
		validateUriAreEqual(serialize(expected), serialize(actual));
	}

	public static void validateUriAreEqual(URI expected, URI actual) {
		validateUriAreEqual(serialize(expected), serialize(actual));
	}

	public static void validateUriAreEqual(String expected, String actual) {
		assertEquals(expected, actual);
	}

	public static void validateUriAreEqualUsingLinkTitle(DomainTransferObject dto, String linkTitle, String expectedUri) {
		URI actualUri = dto.getLink().getUriByTitle(linkTitle);
		validateUriAreEqual(expectedUri, actualUri);
	}

	private static String serialize(String s) {
		if (s == null)
			return "";
		else
			return s;
	}

	private static String serialize(URI uri) {
		if (uri == null)
			return "";
		else
			return uri.toString();
	}
}
