package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters;

import static org.junit.Assert.assertEquals;

import java.net.URI;
import java.net.URISyntaxException;

import org.junit.Test;

public class UriHelperTest {
	@Test
	public void appendNewQueryString() throws URISyntaxException {
		String uriString = "http://server/resource";
		URI uri = new URI(uriString);

		uri = UriHelper.appendQueryString(uri, "param", "value");
		String expectedUriString = "http://server/resource?param=value";
		assertEquals(uri.toString(), expectedUriString);
	}

	@Test
	public void appendNewQueryStringwithSameParamAndValue() throws URISyntaxException {
		String uriString = "http://server/resource?param=value";
		URI uri = new URI(uriString);

		uri = UriHelper.appendQueryString(uri, "param", "value");
		String expectedUriString = "http://server/resource?param=value&param=value";
		assertEquals(uri.toString(), expectedUriString);
	}

	@Test
	public void appendNewQueryStringwithSameParam() throws URISyntaxException {
		String uriString = "http://server/resource?param=oldvalue";
		URI uri = new URI(uriString);

		uri = UriHelper.appendQueryString(uri, "param", "value");
		String expectedUriString = "http://server/resource?param=oldvalue&param=value";
		assertEquals(uri.toString(), expectedUriString);
	}

	@Test
	public void setNewQueryString() throws URISyntaxException {
		String uriString = "http://server/resource";
		URI uri = new URI(uriString);

		uri = UriHelper.setQueryString(uri, "param", "value");
		String expectedUriString = "http://server/resource?param=value";
		assertEquals(uri.toString(), expectedUriString);
	}

	@Test
	public void setNewQueryStringwithSameParamAndValue() throws URISyntaxException {
		String uriString = "http://server/resource?param=value";
		URI uri = new URI(uriString);

		uri = UriHelper.setQueryString(uri, "param", "value");
		String expectedUriString = "http://server/resource?param=value";
		assertEquals(uri.toString(), expectedUriString);
	}

	@Test
	public void setNewQueryStringwithSameParam() throws URISyntaxException {
		String uriString = "http://server/resource?param=oldvalue";
		URI uri = new URI(uriString);

		uri = UriHelper.setQueryString(uri, "param", "value");
		String expectedUriString = "http://server/resource?param=value";
		assertEquals(uri.toString(), expectedUriString);
	}
}
