package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Admission;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;

public class UriDtoValidatorTest {

	@Test
	public void validateValidItem() {
		PatientData dto = new Admission();
		dto.setDataIdentifier("c", "c1");
		dto.setPatientIdentifier("aa", "pid");
		UriDtoValidator.validate(dto);
	}

	@Test(expected = IllegalArgumentException.class)
	public void validateNoId() {
		PatientData dto = new Admission();
		dto.setDataIdentifier("c", "");
		dto.setPatientIdentifier("aa", "pid");
		UriDtoValidator.validate(dto);
	}

	@Test(expected = IllegalArgumentException.class)
	public void validateNoDataIdentifier() {
		PatientData dto = new Admission();
		dto.setPatientIdentifier("aa", "pid");
		UriDtoValidator.validate(dto);
	}

	@Test(expected = IllegalArgumentException.class)
	public void validateNoPatient() {
		PatientData dto = new Admission();
		dto.setDataIdentifier("c", "c1");
		UriDtoValidator.validate(dto);
	}

	@Test(expected = IllegalArgumentException.class)
	public void validateNoAssigningAuthority() {
		PatientData dto = new Admission();
		dto.setDataIdentifier("c", "c1");
		dto.setPatientIdentifier("", "pid");
		UriDtoValidator.validate(dto);
	}

	@Test(expected = IllegalArgumentException.class)
	public void validateNoPatientId() {
		PatientData dto = new Admission();
		dto.setDataIdentifier("c", "c1");
		dto.setPatientIdentifier("aa", "");
		UriDtoValidator.validate(dto);
	}

}
