package com.agilex.healthcare.mobilehealthplatform.utils;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

public class QueryParametersTest {

	@Test
	public void nullQuery() {
		String qs = null;
		QueryParameters queryParameters = new QueryParameters(qs);
		assertNotNull(queryParameters);
		assertEquals(null, queryParameters.getValue("invalid-key"));
		assertFalse(queryParameters.doesKeyExist("invalid-key"));
	}

	@Test
	public void blankQuery() {
		String qs = "";
		QueryParameters queryParameters = new QueryParameters(qs);
		assertNotNull(queryParameters);
		assertEquals(null, queryParameters.getValue("invalid-key"));
		assertFalse(queryParameters.doesKeyExist("invalid-key"));
	}

	@Test
	public void singleItem() {
		String qs = "k=v";
		QueryParameters queryParameters = new QueryParameters(qs);
		assertNotNull(queryParameters);
		assertEquals(null, queryParameters.getValue("invalid-key"));
		assertEquals("v", queryParameters.getValue("k"));
		assertTrue(queryParameters.doesKeyExist("k"));
	}

	@Test
	public void twoItems() {
		String qs = "k1=v1&k2=v2";
		QueryParameters queryParameters = new QueryParameters(qs);
		assertNotNull(queryParameters);
		assertEquals(null, queryParameters.getValue("invalid-key"));
		assertEquals("v1", queryParameters.getValue("k1"));
		assertEquals("v2", queryParameters.getValue("k2"));
		assertTrue(queryParameters.doesKeyExist("k1"));
		assertTrue(queryParameters.doesKeyExist("k2"));
	}

	@Test
	public void itemWithEqualSign() {
		String qs = "k1=v1=v2";
		QueryParameters queryParameters = new QueryParameters(qs);
		assertNotNull(queryParameters);
		assertEquals(null, queryParameters.getValue("invalid-key"));
		// either v1 or v1=v2 would be acceptable
		assertEquals("v1", queryParameters.getValue("k1"));
	}

	@Test
	public void blankValue() {
		String qs = "k1";
		QueryParameters queryParameters = new QueryParameters(qs);
		assertNotNull(queryParameters);

		assertEquals(null, queryParameters.getValue("invalid-key"));
		assertFalse(queryParameters.doesKeyExist("invalid-key"));

		assertEquals(null, queryParameters.getValue("k1"));
		assertTrue(queryParameters.doesKeyExist("k1"));
	}

	@Test
	public void getValueAsBooleanTrue() {
		String qs = "k1=true";
		QueryParameters queryParameters = new QueryParameters(qs);
		assertNotNull(queryParameters);
		assertEquals(true, queryParameters.getValueAsBoolean("k1"));		
	}

	@Test
	public void getValueAsBooleanFalse() {
		String qs = "k1=false";
		QueryParameters queryParameters = new QueryParameters(qs);
		assertNotNull(queryParameters);
		assertEquals(false, queryParameters.getValueAsBoolean("k1"));		
	}

	@Test
	public void getValueAsBooleanBadInput() {
		String qs = "k1=notABoolean";
		QueryParameters queryParameters = new QueryParameters(qs);
		assertNotNull(queryParameters);
		assertEquals(false, queryParameters.getValueAsBoolean("invalid-key"));
		assertEquals(false, queryParameters.getValueAsBoolean("k1"));		
	}
}
