package com.agilex.healthcare.mobilehealthplatform.utils;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.HashMap;
import java.util.Map;

import org.junit.Test;

public class QueryParameterHelperTest {
	@Test
	public void nullQuery() {
		Map<String, String> map = QueryParameterHelper.getQueryMap(null);
		assertNotNull(map);
		assertEquals(0, map.size());
	}

	@Test
	public void blankQuery() {
		Map<String, String> map = QueryParameterHelper.getQueryMap("");
		assertNotNull(map);
		assertEquals(0, map.size());
	}

	@Test
	public void singleItem() {
		HashMap<String, String> map = QueryParameterHelper.getQueryMap("k=v");
		assertEquals(1, map.size());
		assertEquals("v", map.get("k"));
	}

	@Test
	public void twoItems() {
		HashMap<String, String> map = QueryParameterHelper.getQueryMap("k1=v1&k2=v2");
		assertEquals(2, map.size());
		assertEquals("v1", map.get("k1"));
		assertEquals("v2", map.get("k2"));
	}
	@Test
	public void itemWithEqualSign() {
		HashMap<String, String> map = QueryParameterHelper.getQueryMap("k1=v1=v2");
		assertEquals(1, map.size());
		assertEquals("v1", map.get("k1")); //either v1 or v1=v2 would be acceptable
	}

	@Test
	public void blankValue() {
		HashMap<String, String> map = QueryParameterHelper.getQueryMap("k1");
		assertEquals(1, map.size());
		assertEquals(null, map.get("k1"));
	}

}
