package com.agilex.healthcare.mobilehealthplatform.utils;

import static org.junit.Assert.assertEquals;

import java.net.URI;
import java.net.URISyntaxException;

import org.junit.Test;

public class PatientIdExtractorTest {
	@Test
	public void extractFromBlank() {
		assertEquals(null, PatientIdentifierHelper.getPatientIdFromUri(""));
	}

	@Test
	public void extractFromNull() {
		String input = null;
		assertEquals(null, PatientIdentifierHelper.getPatientIdFromUri(input));
	}

	@Test
	public void extractFromNullUri() {
		URI input = null;
		assertEquals(null, PatientIdentifierHelper.getPatientIdFromUri(input));
	}

	@Test
	public void extractFromStringWithoutPattern() {
		assertEquals(null, PatientIdentifierHelper.getPatientIdFromUri("http://server/blah"));
	}

	@Test
	public void extractFromShortString() {
		assertEquals("D123401", PatientIdentifierHelper.getPatientIdFromUri("s/patient/D123401"));
	}

	@Test
	public void extractFromFullUri() throws URISyntaxException {
		URI uri = new URI("http://mobilehealthplatform.elasticbeanstalk.com/rest/patient/D123401");
		assertEquals("D123401", PatientIdentifierHelper.getPatientIdFromUri(uri));
	}
}
