package com.agilex.healthcare.mobilehealthplatform.test;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Community;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.DataLayerFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ServiceRegistry;

public class MockServiceRegistryFactory {
	public static ServiceRegistry create() {
		Community community = mock(Community.class);
		ServiceRegistry mockServiceRegistry = mock(ServiceRegistry.class);
		when(mockServiceRegistry.getPrimaryCommunity()).thenReturn(community);

		DataLayerFactory mockFactory = mock(DataLayerFactory.class);
		when(mockServiceRegistry.getPrimaryCommunity().getDataLayerFactory()).thenReturn(mockFactory);

		return mockServiceRegistry;
	}
}
