package com.agilex.healthcare.mobilehealthplatform.serviceregistry;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.patientcorrelation.PatientCorrelationService;

public class PatientCorrelationEchoMock implements PatientCorrelationService {

	@Override
	public PatientIdentifiers getCorrespondIdentifiers(PatientIdentifier patientIdentifier, String assigningAuthority) {
		return getSingleItemList(assigningAuthority, patientIdentifier.getUniqueId());
	}

	@Override
	public PatientIdentifiers getCorrespondIdentifiers(PatientIdentifier patientIdentifier) {
		return getSingleItemList(patientIdentifier.getAssigningAuthority(), patientIdentifier.getUniqueId());
	}

	private PatientIdentifiers getSingleItemList(String assigningAuthority, String uniqueId) {
		PatientIdentifiers patientIdentifiers = new PatientIdentifiers();
		patientIdentifiers.add(new PatientIdentifier(assigningAuthority, uniqueId));
		return patientIdentifiers;
	}

}
