package com.agilex.healthcare.mobilehealthplatform.serviceregistry;

import java.util.HashMap;
import java.util.Map;

public class MhpObjectFactoryMock extends MhpObjectFactory {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MhpObjectFactory.class);

	Map<String, Object> beans = new HashMap<String, Object>();

	@SuppressWarnings("unchecked")
	@Override
	public <T> T getBean(String beanName) {
		T bean = (T) beans.get(beanName);
		if (bean == null) {
			bean = super.getBean(beanName);
			logger.debug(String.format("using real bean [%s][%s]", beanName, bean));
		} else {
			logger.debug(String.format("used overriden bean [%s][%s]", beanName, bean));
		}
		return bean;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T getBean(String beanName, Class<T> requiredType) {
		T bean = (T) getBean(beanName);
		return bean;
	}

	public <T> void setBean(String beanName, T bean) {
		beans.put(beanName, bean);
	}

}
