package com.agilex.healthcare.mobilehealthplatform.security;

import java.util.ArrayList;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

public class VoterHelperTest {

	@Test
	public void canGetPatientIdentifierFromUri(){
		String uri = "http://localhost:8080/MobileHealthPlatformWeb/rest/patient/mock-aa/D123401";
		
		PatientIdentifier pi = VoterHelper.getPatientIdentifierFromUri(uri);
		
		Assert.assertNotNull(pi);
		Assert.assertEquals("D123401", pi.getUniqueId());
		Assert.assertEquals("mock-aa", pi.getAssigningAuthority());
	}

	@Test
	public void canGetPatientIdentifierFromNotificationsUri(){
		String uri = "http://localhost:8080/MobileHealthPlatformWeb/rest/notification-service/user/id/EDIPI/D123401";
		
		PatientIdentifier pi = VoterHelper.getPatientIdentifierFromUri(uri);
		
		Assert.assertNotNull(pi);
		Assert.assertEquals("D123401", pi.getUniqueId());
		Assert.assertEquals("EDIPI", pi.getAssigningAuthority());
	}
	
	@Test
	public void userHasRole(){
		List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
		authorities.add(new SimpleGrantedAuthority(Roles.ROLE_CONSUMER));
		authorities.add(new SimpleGrantedAuthority("ROLE_UNIT_TEST"));
		
		Assert.assertTrue(VoterHelper.hasRole(authorities , "ROLE_UNIT_TEST"));
		Assert.assertFalse(VoterHelper.hasRole(authorities, "ROLE_BOGUS"));
	}
}
