package com.agilex.healthcare.mobilehealthplatform.patientcorrelation;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;

public class PatientCorrelationMemoryImplementationTest {
 
	private PatientCorrelationService correlationService = new PatientCorrelationMock();
	@Test
	public void getCorrelations() {
		PatientIdentifier enterpriseId = new PatientIdentifier("EDIPI", "D123401");
		assertEquals(7, correlationService.getCorrespondIdentifiers(enterpriseId).size());
	}
 
	@Test
	public void getTargetedCorrelationsForPatient() {
		PatientIdentifier enterpriseId = new PatientIdentifier("EDIPI", "D123401");
		assertEquals(2, correlationService.getCorrespondIdentifiers(enterpriseId, "ICN").size());
		assertEquals(1, correlationService.getCorrespondIdentifiers(enterpriseId, "DFN-688").size());
	}

	@Test
	public void getTargetedCorrelationsForNonExistantPatient() {
		PatientIdentifier enterpriseId = new PatientIdentifier("EDIPI", "noidentifier");
		PatientIdentifiers correlatedIds = correlationService.getCorrespondIdentifiers(enterpriseId);
		assertEquals(0, correlatedIds.size());
	}
}