package com.agilex.healthcare.mobilehealthplatform.patientcorrelation;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;

public class PatientCorrelationIntegrationMockTest {
	private PatientCorrelationService correlationService = new PatientCorrelationIntegrationMock();

	@Test
	public void getCorrelations() {
		PatientIdentifier enterpriseId = new PatientIdentifier("EDIPI", "1244420300");
		PatientIdentifiers correspondIdentifiers = correlationService.getCorrespondIdentifiers(enterpriseId, "ICN");
		assertEquals(1, correspondIdentifiers.size());
		assertEquals("ICN", correspondIdentifiers.get(0).getAssigningAuthority());
		assertEquals("1002772146V123456", correspondIdentifiers.get(0).getUniqueId());
	}

    /// Write a test to ensure you can get all 3 identifiers given an EDIPI
    @Test
    public void validateRuben() {
        PatientIdentifier rubenId = new PatientIdentifier("EDIPI", "1099737332");
        PatientIdentifiers correspondingIdentifiers = correlationService.getCorrespondIdentifiers(rubenId);
        assertEquals(3, correspondingIdentifiers.size());

        //1011491687V235101
        PatientIdentifiers icnMatches = correlationService.getCorrespondIdentifiers(rubenId, "ICN");
        assertEquals(1, icnMatches.size());
        assertEquals("1011491687V235101", icnMatches.get(0).getUniqueId());

        // 22679
        PatientIdentifiers dfnMatches = correlationService.getCorrespondIdentifiers(rubenId, "DFN-516");
        assertEquals(1, dfnMatches.size());
        assertEquals("22679", dfnMatches.get(0).getUniqueId());

        PatientIdentifiers edipiMatches = correlationService.getCorrespondIdentifiers(rubenId, "EDIPI");
        assertEquals(1, edipiMatches.size());
        assertEquals("1099737332", edipiMatches.get(0).getUniqueId());
    }
}
