package com.agilex.healthcare.mobilehealthplatform.ical;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.UUID;

import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Summary;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.utility.DateHelper;

public class iCalHelperTest {
	private Appointments appointments;
	private String patientId = UUID.randomUUID().toString();

	@Before
	public void setup() {
		appointments = new Appointments();

		Appointment appointment = new Appointment();
		appointment.setPatientId(patientId);
		appointment.setAppointmentStartDate(DateHelper.parseDateTime("1/2/2012 11:00:00"));
		appointment.setAppointmentEndDate(DateHelper.parseDateTime("1/2/2012 12:00:00"));
		appointment.setReasonForVisit("X-Ray");
		appointment.setClinicName("Sample Clinic Name");
		appointment.setClinicalNotes("Sample Clinical Notes");
		appointments.add(appointment);

		Appointment apptNoEndDate = new Appointment();
		apptNoEndDate.setPatientId(patientId);
		apptNoEndDate.setAppointmentStartDate(DateHelper.parseDateTime("1/2/2012 10:00:00"));
		apptNoEndDate.setAppointmentDuration(new Integer(30));
		apptNoEndDate.setReasonForVisit("X-Ray");
		apptNoEndDate.setClinicName("Sample Clinic Name");
		apptNoEndDate.setClinicalNotes("Sample Clinical Notes");
		appointments.add(apptNoEndDate);

		Appointment emptyAppointment = new Appointment();
		emptyAppointment.setPatientId(patientId);
		emptyAppointment.setAppointmentStartDate(DateHelper.parseDateTime("1/2/2012 10:00:00"));
		emptyAppointment.setAppointmentDuration(new Integer(30));
		appointments.add(emptyAppointment);
		
	}

	@Test
	public void calendarHasAnEvent() {
		Calendar calendar = ICalHelper.transformAppointmentsToIcal(appointments);
		assertNotNull(calendar);
		VEvent firstEvent = (VEvent) calendar.getComponents().get(0);
		assertNotNull(firstEvent.toString());
	}

	private VEvent getEvent(int i) {
		Calendar calendar = ICalHelper.transformAppointmentsToIcal(appointments);
		return (VEvent) calendar.getComponents().get(i);
	}
	
	@Test
	public void eventHasProperties() {
		PropertyList properties = this.getEvent(0).getProperties();
		assertNotNull(properties);
	}

	@Test
	public void startDateTest() {
		DtStart startDate = this.getEvent(0).getStartDate();
		assertNotNull(startDate);
		assertEquals("20120102T110000", startDate.getValue());
	}

	@Test
	public void endDateTest() {
		DtEnd endDate = this.getEvent(0).getEndDate();
		assertNotNull(endDate);
		assertEquals("20120102T120000", endDate.getValue());
	}
	
	@Test
	public void endDateUsingDurationTest() {
		DtEnd endDate = this.getEvent(1).getEndDate();
		assertNotNull(endDate);
		assertEquals("20120102T103000", endDate.getValue());
	}

	@Test
	public void summaryTest() {
		Summary summary = this.getEvent(0).getSummary();
		assertNotNull(summary);
		assertEquals("X-Ray", summary.getValue());
	}

	@Test
	public void locationTest() {
		Location location = this.getEvent(0).getLocation();
		assertNotNull(location);
		assertEquals("Sample Clinic Name", location.getValue());
	}
	
	@Test 
	public void descriptionTest() {
		Description description = this.getEvent(0).getDescription();
		assertNotNull(description);
		assertEquals("Sample Clinical Notes", description.getValue());
	}
	
	@Test
	public void emptyEventHasProperties() {
		PropertyList properties = this.getEvent(2).getProperties();
		assertNotNull(properties);
	}

	@Test
	public void emptyEventSummaryTest() {
		Summary summary = this.getEvent(2).getSummary();
		assertNotNull(summary);
		assertEquals(null, summary.getValue());
	}

	@Test
	public void emptyEventLocationTest() {
		Location location = this.getEvent(2).getLocation();
		assertNotNull(location);
		assertEquals(null, location.getValue());
	}
	
	@Test 
	public void emptyEventDescriptionTest() {
		Description description = this.getEvent(2).getDescription();
		assertNotNull(description);
		assertEquals(null, description.getValue());
	}
	
}
