package com.agilex.healthcare.mobilehealthplatform.datalayer.staffdirectory;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.StaffDirectorySearchResult;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffDirectorySearchResults;

public class StaffDirectoryDataServiceTest {

	private StaffDirectoryDataService staffDirectoryDataService;
	private final String facilitySiteCode = "testfacility";
	private final String email = "testemail@email";
	private final String firstName = "firstname";
	private final String lastName = "lastname";
	private final String firstAndLastNameComma = lastName + "," + firstName;
	private final String firstAndLastNameCommaAndSpace = lastName + ", " + firstName;
	private final String firstAndLastNameSpace = firstName + " " + lastName;
	private final String phoneNumber = "1";
	
	private final String emailResultName = "email";
	private final String firstAndLastNameResultName = "firstAndLastName";
	private final String firstOrLastNameResultName = "firstOrLastName";
	private final String lastNameResultName = "lastName";
	private final String lastNameInFirstNameResultName = "lastNameInFirstName";
	private final String phoneNumberResultName = "phoneNumber";

	private StaffDirectorySearchResults emailResults = generateResults(new StaffDirectorySearchResult(emailResultName));
	private StaffDirectorySearchResults firstAndLastNameResults = generateResults(new StaffDirectorySearchResult(firstAndLastNameResultName));
	private StaffDirectorySearchResults firstOrLastNameResults = generateResults(new StaffDirectorySearchResult(firstOrLastNameResultName));
	private StaffDirectorySearchResults lastNameResults = generateResults(new StaffDirectorySearchResult(lastNameResultName));
	private StaffDirectorySearchResults lastNameInfirstNameResults = generateResults(new StaffDirectorySearchResult(lastNameInFirstNameResultName));
	private StaffDirectorySearchResults phoneNumberResults = generateResults(new StaffDirectorySearchResult(phoneNumberResultName));
	
	private StaffDirectorySearchResults generateResults(StaffDirectorySearchResult result) {
		StaffDirectorySearchResults results = new StaffDirectorySearchResults();
		results.add(result);
		
		return results;
	}
	
	@Before
	public void setUp() {
		StaffDirectoryDataLayer mockDl = mock(StaffDirectoryDataLayer.class);
		when(mockDl.searchByEmail(facilitySiteCode, email.trim().toUpperCase())).thenReturn(emailResults);
		when(mockDl.searchByFirstOrLastname(facilitySiteCode, email.trim().toUpperCase(), email.trim().toUpperCase())).thenReturn(firstOrLastNameResults);
		when(mockDl.searchByFirstAndLastname(facilitySiteCode, firstName.trim().toUpperCase(), lastName.trim().toUpperCase())).thenReturn(firstAndLastNameResults);
		when(mockDl.searchByFirstOrLastname(facilitySiteCode, null, lastName.trim().toUpperCase())).thenReturn(lastNameResults);
		when(mockDl.searchByFirstOrLastname(facilitySiteCode, lastName.trim().toUpperCase(), null)).thenReturn(lastNameInfirstNameResults);
		when(mockDl.searchByPhoneNumber(facilitySiteCode, phoneNumber.trim().toUpperCase())).thenReturn(phoneNumberResults);
		
		staffDirectoryDataService = new StaffDirectoryDataService(mockDl);
	}
	
	@After
	public void clearContext() {
	}
	
	@Test
	public void verifyEmailSearch() {
		StaffDirectorySearchResults results = staffDirectoryDataService.queryStaffBySite(facilitySiteCode, email);
		
		assertNotNull(results);
		assertEquals(1, results.size());
		assertEquals(emailResultName, results.get(0).getName());
	}
	
	@Test
	public void verifyFirstAndLastNameByCommaSearch() {
		// if  or space, assume firstname and lastname search
		StaffDirectorySearchResults results = staffDirectoryDataService.queryStaffBySite(facilitySiteCode, firstAndLastNameComma);
		assertNotNull(results);
		assertEquals(1, results.size());
		assertEquals(firstAndLastNameResultName, results.get(0).getName());
	}
	
	@Test
	public void verifyFirstAndLastNameByCommaAndSpaceSearch() {
		// if  or space, assume firstname and lastname search
		StaffDirectorySearchResults results = staffDirectoryDataService.queryStaffBySite(facilitySiteCode, firstAndLastNameCommaAndSpace);
		assertNotNull(results);
		assertEquals(1, results.size());
		assertEquals(firstAndLastNameResultName, results.get(0).getName());
	}
	
	@Test
	public void verifyFirstAndLastNameBySpaceSearch() {
		// if  or space, assume firstname and lastname search
		StaffDirectorySearchResults results = staffDirectoryDataService.queryStaffBySite(facilitySiteCode, firstAndLastNameSpace);
		assertNotNull(results);
		assertEquals(1, results.size());
		assertEquals(firstAndLastNameResultName, results.get(0).getName());
	}
	
	@Test
	public void verifyPhoneNumberSearch() {
		// if number, assume phone number search
		StaffDirectorySearchResults results = staffDirectoryDataService.queryStaffBySite(facilitySiteCode, phoneNumber);
		assertNotNull(results);
		assertEquals(1, results.size());
		assertEquals(phoneNumberResultName, results.get(0).getName());
	}
	
}
